/*
 * Decompiled with CFR 0.152.
 */
package rx.lang.jruby;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;
import rx.util.functions.FunctionLanguageAdaptor;

public class JRubyAdaptor
implements FunctionLanguageAdaptor {
    public Object call(Object function, Object[] args) {
        RubyProc rubyProc = (RubyProc)function;
        Ruby ruby = rubyProc.getRuntime();
        IRubyObject[] rubyArgs = new IRubyObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            rubyArgs[i] = JavaEmbedUtils.javaToRuby((Ruby)ruby, (Object)args[i]);
        }
        return rubyProc.getBlock().call(ruby.getCurrentContext(), rubyArgs);
    }

    public Class<?>[] getFunctionClass() {
        return new Class[]{RubyProc.class};
    }

    public static class UnitTest {
        @Mock
        ScriptAssertion assertion;
        @Mock
        Observer<Integer> w;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testCreateViaGroovy() {
            this.runGroovyScript("Observable.create(lambda{|it| it.onNext('hello');it.onCompleted();}).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received("hello");
        }

        @Test
        public void testFilterViaGroovy() {
            this.runGroovyScript("Observable.filter(Observable.toObservable(1, 2, 3), lambda{|it| it >= 2}).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(1L);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(2L);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(3L);
        }

        @Test
        public void testLast() {
            String script = "mockApiCall.getObservable().last().subscribe(lambda{|result| a.received(result)})";
            this.runGroovyScript(script);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received("hello_1");
        }

        @Test
        public void testMap() {
            String script = "mockApiCall.getObservable().map(lambda{|v| 'say' + v}).subscribe(lambda{|result| a.received(result)});";
            this.runGroovyScript(script);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received("sayhello_1");
        }

        @Test
        public void testMaterializeViaGroovy() {
            this.runGroovyScript("Observable.materialize(Observable.toObservable(1, 2, 3)).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)4))).received(Mockito.any(Notification.class));
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).error((Exception)Mockito.any(Exception.class));
        }

        @Test
        public void testScriptWithMaterialize() {
            String script = "mockApiCall.getObservable().materialize().subscribe(lambda{|result| a.received(result)});";
            this.runGroovyScript(script);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)2))).received(Mockito.any(Notification.class));
        }

        @Test
        public void testScriptWithMerge() {
            String script = "Observable.merge(mockApiCall.getObservable(), mockApiCall.getObservable()).subscribe(lambda{|result| a.received(result)});";
            this.runGroovyScript(script);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received("hello_1");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received("hello_2");
        }

        @Test
        public void testScriptWithOnNext() {
            String script = "mockApiCall.getObservable().subscribe(lambda{|result| a.received(result)})";
            this.runGroovyScript(script);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion)).received("hello_1");
        }

        @Test
        public void testSkipTakeViaGroovy() {
            this.runGroovyScript("Observable.skip(Observable.toObservable(1, 2, 3), 1).take(1).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(1);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(2L);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(3);
        }

        @Test
        public void testSkipViaGroovy() {
            this.runGroovyScript("Observable.skip(Observable.toObservable(1, 2, 3), 2).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(1);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(2);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(3L);
        }

        @Test
        public void testTakeViaGroovy() {
            this.runGroovyScript("Observable.take(Observable.toObservable(1, 2, 3), 2).subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(1L);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(2L);
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)0))).received(3);
        }

        @Test
        public void testToSortedList() {
            this.runGroovyScript("mockApiCall.getNumbers().toSortedList().subscribe(lambda{|result| a.received(result)});");
            ((ScriptAssertion)Mockito.verify((Object)this.assertion, (VerificationMode)Mockito.times((int)1))).received(Arrays.asList(1, 2, 3, 4, 5));
        }

        private void runGroovyScript(String script) {
            ScriptingContainer container = new ScriptingContainer();
            container.put("mockApiCall", (Object)new TestFactory());
            container.put("a", (Object)this.assertion);
            StringBuilder b = new StringBuilder();
            b.append("import \"rx.Observable\"").append("\n");
            b.append("class Observable").append("\n");
            b.append("  java_alias :subscribe, :subscribe, [java.lang.Object]").append("\n");
            b.append("end").append("\n");
            b.append(script);
            container.runScriptlet(b.toString());
        }

        private static class TestObservable
        extends Observable<String> {
            private final int count;

            public TestObservable(int count) {
                super((Func1)new Func1<Observer<String>, Subscription>(){

                    public Subscription call(Observer<String> t1) {
                        return null;
                    }
                });
                this.count = count;
            }

            public Subscription subscribe(Observer<String> observer) {
                observer.onNext((Object)("hello_" + this.count));
                observer.onCompleted();
                return new Subscription(){

                    public void unsubscribe() {
                    }
                };
            }
        }

        public static class TestFactory {
            int counter = 1;

            public Observable<Integer> getNumbers() {
                return Observable.toObservable((Object[])new Integer[]{1, 3, 2, 5, 4});
            }

            public TestObservable getObservable() {
                return new TestObservable(this.counter++);
            }
        }

        private static interface ScriptAssertion {
            public void error(Exception var1);

            public void received(Object var1);
        }
    }
}

