/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public class StringObservable {
    public static Observable<String> decode(Observable<byte[]> src, String charsetName) {
        return StringObservable.decode(src, Charset.forName(charsetName));
    }

    public static Observable<String> decode(Observable<byte[]> src, Charset charset) {
        return StringObservable.decode(src, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<String> decode(final Observable<byte[]> src, final CharsetDecoder charsetDecoder) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<String>(){

            public Subscription onSubscribe(final Observer<? super String> observer) {
                return src.subscribe((Observer)new Observer<byte[]>(){
                    private ByteBuffer leftOver = null;

                    public void onCompleted() {
                        if (this.process(null, this.leftOver, true)) {
                            observer.onCompleted();
                        }
                    }

                    public void onError(Throwable e) {
                        if (this.process(null, this.leftOver, true)) {
                            observer.onError(e);
                        }
                    }

                    public void onNext(byte[] bytes) {
                        this.process(bytes, this.leftOver, false);
                    }

                    public boolean process(byte[] next, ByteBuffer last, boolean endOfInput) {
                        ByteBuffer bb;
                        if (last != null) {
                            if (next != null) {
                                bb = ByteBuffer.allocate(last.remaining() + next.length);
                                bb.put(last);
                                bb.put(next);
                                bb.flip();
                            } else {
                                bb = last;
                            }
                        } else if (next != null) {
                            bb = ByteBuffer.wrap(next);
                        } else {
                            return true;
                        }
                        CharBuffer cb = CharBuffer.allocate((int)((float)bb.limit() * charsetDecoder.averageCharsPerByte()));
                        CoderResult cr = charsetDecoder.decode(bb, cb, endOfInput);
                        cb.flip();
                        if (cr.isError()) {
                            try {
                                cr.throwException();
                            }
                            catch (CharacterCodingException e) {
                                observer.onError((Throwable)e);
                                return false;
                            }
                        }
                        this.leftOver = bb.remaining() > 0 ? bb : null;
                        String string = cb.toString();
                        if (!string.isEmpty()) {
                            observer.onNext((Object)string);
                        }
                        return true;
                    }
                });
            }
        });
    }

    public static Observable<byte[]> encode(Observable<String> src, String charsetName) {
        return StringObservable.encode(src, Charset.forName(charsetName));
    }

    public static Observable<byte[]> encode(Observable<String> src, Charset charset) {
        return StringObservable.encode(src, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<byte[]> encode(Observable<String> src, final CharsetEncoder charsetEncoder) {
        return src.map((Func1)new Func1<String, byte[]>(){

            public byte[] call(String str) {
                ByteBuffer bb;
                CharBuffer cb = CharBuffer.wrap(str);
                try {
                    bb = charsetEncoder.encode(cb);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException(e);
                }
                return Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
            }
        });
    }

    public static Observable<String> stringConcat(Observable<String> src) {
        return src.aggregate((Func2)new Func2<String, String, String>(){

            public String call(String a, String b) {
                return a + b;
            }
        });
    }

    public static Observable<String> split(final Observable<String> src, String regex) {
        final Pattern pattern = Pattern.compile(regex);
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<String>(){

            public Subscription onSubscribe(final Observer<? super String> observer) {
                return src.subscribe((Observer)new Observer<String>(){
                    private String leftOver = null;
                    private int emptyPartCount = 0;

                    public void onCompleted() {
                        this.output(this.leftOver);
                        observer.onCompleted();
                    }

                    public void onError(Throwable e) {
                        this.output(this.leftOver);
                        observer.onError(e);
                    }

                    public void onNext(String segment) {
                        String[] parts = pattern.split(segment, -1);
                        if (this.leftOver != null) {
                            parts[0] = this.leftOver + parts[0];
                        }
                        for (int i = 0; i < parts.length - 1; ++i) {
                            String part = parts[i];
                            this.output(part);
                        }
                        this.leftOver = parts[parts.length - 1];
                    }

                    private void output(String part) {
                        if (part.isEmpty()) {
                            ++this.emptyPartCount;
                        } else {
                            while (this.emptyPartCount > 0) {
                                observer.onNext((Object)"");
                                --this.emptyPartCount;
                            }
                            observer.onNext((Object)part);
                        }
                    }
                });
            }
        });
    }

    public static <T> Observable<String> join(final Observable<T> source, final CharSequence separator) {
        return Observable.create((Observable.OnSubscribeFunc)new Observable.OnSubscribeFunc<String>(){

            public Subscription onSubscribe(final Observer<? super String> t1) {
                return source.subscribe(new Observer<T>(){
                    boolean mayAddSeparator;
                    StringBuilder b = new StringBuilder();

                    public void onNext(T args) {
                        if (this.mayAddSeparator) {
                            this.b.append(separator);
                        }
                        this.mayAddSeparator = true;
                        this.b.append(String.valueOf(args));
                    }

                    public void onError(Throwable e) {
                        this.b = null;
                        t1.onError(e);
                    }

                    public void onCompleted() {
                        String str = this.b.toString();
                        this.b = null;
                        t1.onNext((Object)str);
                        t1.onCompleted();
                    }
                });
            }
        });
    }
}

