/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.aws.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.networknt.aws.lambda.LambdaInvokerConfig;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.handler.Handler;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.AbstractMetricsHandler;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.net.URI;
import java.time.Duration;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;

public class LambdaFunctionHandler
implements LightHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(LambdaFunctionHandler.class);
    private static LambdaInvokerConfig config;
    private static final String MISSING_ENDPOINT_FUNCTION = "ERR10063";
    private static final String EMPTY_LAMBDA_RESPONSE = "ERR10064";
    private static AbstractMetricsHandler metricsHandler;
    private static LambdaAsyncClient client;

    public LambdaFunctionHandler() {
        Map handlers;
        config = LambdaInvokerConfig.load();
        SdkAsyncHttpClient asyncHttpClient = NettyNioAsyncHttpClient.builder().readTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).writeTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).connectionTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).build();
        ClientOverrideConfiguration overrideConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(config.getApiCallTimeout())).apiCallAttemptTimeout(Duration.ofSeconds(config.getApiCallAttemptTimeout())).build();
        LambdaAsyncClientBuilder builder = (LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)LambdaAsyncClient.builder().region(Region.of((String)config.getRegion()))).httpClient(asyncHttpClient)).overrideConfiguration(overrideConfig);
        if (!StringUtils.isEmpty((CharSequence)config.getEndpointOverride())) {
            builder.endpointOverride(URI.create(config.getEndpointOverride()));
        }
        client = (LambdaAsyncClient)builder.build();
        if (config.isMetricsInjection() && (metricsHandler = (AbstractMetricsHandler)(handlers = Handler.getHandlers()).get("metrics")) == null) {
            logger.error("An instance of MetricsHandler is not configured in the handler.yml.");
        }
        ModuleRegistry.registerModule((String)"lambda-invoker", (String)LambdaFunctionHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("lambda-invoker"), null);
        if (logger.isInfoEnabled()) {
            logger.info("LambdaFunctionHandler is loaded.");
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        long startTime = System.nanoTime();
        String httpMethod = exchange.getRequestMethod().toString();
        String requestPath = exchange.getRequestPath();
        Map<String, String> headers = this.convertHeaders(exchange.getRequestHeaders());
        Map<String, String> queryStringParameters = this.convertQueryParameters(exchange.getQueryParameters());
        Map<String, String> pathParameters = this.convertPathParameters(exchange.getPathParameters());
        String body = (String)exchange.getAttachment(AttachmentConstants.REQUEST_BODY_STRING);
        if (logger.isTraceEnabled()) {
            logger.trace("requestPath = " + requestPath + " httpMethod = " + httpMethod + " body = " + body);
            logger.trace("headers = " + JsonMapper.toJson(headers));
            logger.trace("queryParameters = " + JsonMapper.toJson(queryStringParameters));
            logger.trace("pathParameters = " + JsonMapper.toJson(pathParameters));
        }
        String endpoint = (String)((Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)).get("endpoint");
        String functionName = config.getFunctions().get(endpoint);
        if (functionName == null) {
            this.setExchangeStatus(exchange, MISSING_ENDPOINT_FUNCTION, new Object[]{endpoint});
            if (config.isMetricsInjection() && metricsHandler != null) {
                metricsHandler.injectMetrics(exchange, startTime, config.getMetricsName(), endpoint);
            }
            return;
        }
        APIGatewayProxyRequestEvent requestEvent = new APIGatewayProxyRequestEvent();
        requestEvent.setHttpMethod(httpMethod);
        requestEvent.setPath(requestPath);
        requestEvent.setHeaders(headers);
        requestEvent.setPathParameters(pathParameters);
        requestEvent.setQueryStringParameters(queryStringParameters);
        requestEvent.setBody(body == null ? null : body);
        String requestBody = JsonMapper.objectMapper.writeValueAsString((Object)requestEvent);
        if (logger.isTraceEnabled()) {
            logger.trace("requestBody = {}", (Object)requestBody);
        }
        String res = this.invokeFunction(client, functionName, requestBody);
        if (logger.isDebugEnabled()) {
            logger.debug("response = {}", (Object)res);
        }
        if (res == null) {
            this.setExchangeStatus(exchange, EMPTY_LAMBDA_RESPONSE, new Object[]{functionName});
            if (config.isMetricsInjection() && metricsHandler != null) {
                metricsHandler.injectMetrics(exchange, startTime, config.getMetricsName(), endpoint);
            }
            return;
        }
        APIGatewayProxyResponseEvent responseEvent = (APIGatewayProxyResponseEvent)JsonMapper.fromJson((String)res, APIGatewayProxyResponseEvent.class);
        this.setResponseHeaders(exchange, responseEvent.getHeaders());
        exchange.setStatusCode(responseEvent.getStatusCode().intValue());
        exchange.getResponseSender().send(responseEvent.getBody());
        if (config.isMetricsInjection() && metricsHandler != null) {
            metricsHandler.injectMetrics(exchange, startTime, config.getMetricsName(), endpoint);
        }
    }

    private String invokeFunction(LambdaAsyncClient client, String functionName, String requestBody) {
        Object response = null;
        try {
            SdkBytes payload = SdkBytes.fromUtf8String((String)requestBody);
            InvokeRequest request = (InvokeRequest)InvokeRequest.builder().functionName(functionName).logType(config.getLogType()).payload(payload).build();
            CompletionStage futureResponse = ((CompletableFuture)client.invoke(request).thenApply(res -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("LambdaFunctionHandler.invokeFunction response: {}", res);
                }
                return res.payload().asUtf8String();
            })).exceptionally(e -> {
                logger.error("Error invoking lambda function: {}", (Object)functionName, e);
                return null;
            });
            return (String)((CompletableFuture)futureResponse).get();
        }
        catch (InterruptedException | ExecutionException e2) {
            logger.error("LambdaException", (Throwable)e2);
            return null;
        }
    }

    private Map<String, String> convertHeaders(HeaderMap headerMap) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headerMap != null) {
            for (HttpString headerName : headerMap.getHeaderNames()) {
                headers.put(headerName.toString(), headerMap.get(headerName).getFirst());
            }
        }
        return headers;
    }

    private Map<String, String> convertQueryParameters(Map<String, Deque<String>> params) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (params != null) {
            for (String key : params.keySet()) {
                queryParameters.put(key, params.get(key).getFirst());
            }
        }
        return queryParameters;
    }

    private Map<String, String> convertPathParameters(Map<String, Deque<String>> params) {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        if (params != null) {
            for (String key : params.keySet()) {
                pathParameters.put(key, params.get(key).getFirst());
            }
        }
        return pathParameters;
    }

    private void setResponseHeaders(HttpServerExchange exchange, Map<String, String> headers) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                exchange.getResponseHeaders().put(new HttpString(key), headers.get(key));
            }
        }
    }

    public static void reload() {
        Map handlers;
        config.reload();
        SdkAsyncHttpClient asyncHttpClient = NettyNioAsyncHttpClient.builder().readTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).writeTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).connectionTimeout(Duration.ofMillis(config.getApiCallAttemptTimeout())).build();
        ClientOverrideConfiguration overrideConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(config.getApiCallTimeout())).apiCallAttemptTimeout(Duration.ofSeconds(config.getApiCallAttemptTimeout())).build();
        LambdaAsyncClientBuilder builder = (LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)LambdaAsyncClient.builder().region(Region.of((String)config.getRegion()))).httpClient(asyncHttpClient)).overrideConfiguration(overrideConfig);
        if (!StringUtils.isEmpty((CharSequence)config.getEndpointOverride())) {
            builder.endpointOverride(URI.create(config.getEndpointOverride()));
        }
        client = (LambdaAsyncClient)builder.build();
        if (config.isMetricsInjection() && (metricsHandler = (AbstractMetricsHandler)(handlers = Handler.getHandlers()).get("metrics")) == null) {
            logger.error("An instance of MetricsHandler is not configured in the handler.yml.");
        }
        ModuleRegistry.registerModule((String)"lambda-invoker", (String)LambdaFunctionHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("lambda-invoker"), null);
        if (logger.isInfoEnabled()) {
            logger.info("LambdaFunctionHandler is loaded.");
        }
    }
}

