/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.aws.lambda;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaInvokerConfig {
    private static final Logger logger = LoggerFactory.getLogger(LambdaInvokerConfig.class);
    public static final String CONFIG_NAME = "lambda-invoker";
    private static final String REGION = "region";
    private static final String ENDPOINT_OVERRIDE = "endpointOverride";
    private static final String API_CALL_TIMEOUT = "apiCallTimeout";
    private static final String API_CALL_ATTEMPT_TIMEOUT = "apiCallAttemptTimeout";
    private static final String LOG_TYPE = "logType";
    private static final String FUNCTIONS = "functions";
    private static final String METRICS_INJECTION = "metricsInjection";
    private static final String METRICS_NAME = "metricsName";
    private String region;
    private String endpointOverride;
    private int apiCallTimeout;
    private int apiCallAttemptTimeout;
    private String logType;
    private Map<String, String> functions;
    private boolean metricsInjection;
    private String metricsName;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(String endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public int getApiCallTimeout() {
        return this.apiCallTimeout;
    }

    public void setApiCallTimeout(int apiCallTimeout) {
        this.apiCallTimeout = apiCallTimeout;
    }

    public int getApiCallAttemptTimeout() {
        return this.apiCallAttemptTimeout;
    }

    public void setApiCallAttemptTimeout(int apiCallAttemptTimeout) {
        this.apiCallAttemptTimeout = apiCallAttemptTimeout;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, String> functions) {
        this.functions = functions;
    }

    public boolean isMetricsInjection() {
        return this.metricsInjection;
    }

    public void setMetricsInjection(boolean metricsInjection) {
        this.metricsInjection = metricsInjection;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public LambdaInvokerConfig() {
        this(CONFIG_NAME);
    }

    private LambdaInvokerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigMap();
    }

    public static LambdaInvokerConfig load() {
        return new LambdaInvokerConfig();
    }

    public static LambdaInvokerConfig load(String configName) {
        return new LambdaInvokerConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigMap();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(REGION);
        if (object != null) {
            this.region = (String)object;
        }
        if ((object = this.mappedConfig.get(ENDPOINT_OVERRIDE)) != null) {
            this.endpointOverride = (String)object;
        }
        if ((object = this.mappedConfig.get(API_CALL_TIMEOUT)) != null) {
            this.apiCallTimeout = Config.loadIntegerValue((String)API_CALL_TIMEOUT, (Object)object);
        }
        if ((object = this.mappedConfig.get(API_CALL_ATTEMPT_TIMEOUT)) != null) {
            this.apiCallAttemptTimeout = Config.loadIntegerValue((String)API_CALL_ATTEMPT_TIMEOUT, (Object)object);
        }
        if ((object = this.mappedConfig.get(LOG_TYPE)) != null) {
            this.logType = (String)object;
        }
        if ((object = this.getMappedConfig().get(METRICS_INJECTION)) != null) {
            this.metricsInjection = Config.loadBooleanValue((String)METRICS_INJECTION, (Object)object);
        }
        if ((object = this.getMappedConfig().get(METRICS_NAME)) != null) {
            this.metricsName = (String)object;
        }
    }

    private void setConfigMap() {
        if (this.mappedConfig.get(FUNCTIONS) != null) {
            Object object = this.mappedConfig.get(FUNCTIONS);
            this.functions = new HashMap<String, String>();
            if (object instanceof String) {
                String s = (String)object;
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("functions s = " + s);
                }
                if (s.startsWith("{")) {
                    try {
                        this.functions = (Map)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the functions json with a map of string and string.");
                    }
                } else {
                    String[] pairs = s.split(",");
                    for (int i = 0; i < pairs.length; ++i) {
                        String pair = pairs[i];
                        String[] keyValue = pair.split(":");
                        this.functions.put(keyValue[0], keyValue[1]);
                    }
                }
            } else if (object instanceof Map) {
                this.functions = (Map)object;
            } else {
                throw new ConfigException("functions must be a string string map.");
            }
        }
    }
}

