/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.aws.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.mservicetech.openapi.common.RequestEntity;
import com.mservicetech.openapi.common.Status;
import com.mservicetech.openapi.validation.OpenApiValidator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaSchemaValidator {
    static final Logger logger = LoggerFactory.getLogger(LambdaSchemaValidator.class);
    static final String CONTENT_TYPE = "application/json";

    public APIGatewayProxyResponseEvent validateRequest(APIGatewayProxyRequestEvent requestEvent) {
        Status status;
        OpenApiValidator openApiValidator = new OpenApiValidator("openapi.yaml");
        RequestEntity requestEntity = new RequestEntity();
        requestEntity.setQueryParameters(requestEvent.getQueryStringParameters());
        requestEntity.setPathParameters(requestEvent.getPathParameters());
        requestEntity.setHeaderParameters(requestEvent.getHeaders());
        if (requestEvent.getBody() != null) {
            requestEntity.setRequestBody(requestEvent.getBody());
            requestEntity.setContentType(CONTENT_TYPE);
        }
        if ((status = openApiValidator.validateRequestPath(requestEvent.getPath(), requestEvent.getHttpMethod(), requestEntity)) != null) {
            return this.createErrorResponse(status.getStatusCode(), status.getCode(), status.getDescription());
        }
        return null;
    }

    private APIGatewayProxyResponseEvent createErrorResponse(int statusCode, String errorCode, String errorMessage) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", CONTENT_TYPE);
        String body = "{\"statusCode\":" + statusCode + ",\"code\":\"" + errorCode + ",\"description\":\"" + errorMessage + "\"}";
        if (logger.isDebugEnabled()) {
            logger.debug("error info:" + body);
        }
        return new APIGatewayProxyResponseEvent().withHeaders(headers).withStatusCode(Integer.valueOf(statusCode)).withBody(body);
    }
}

