/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.aws.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.aws.lambda.validator.RequestValidator;
import com.networknt.aws.lambda.validator.SchemaValidator;
import com.networknt.config.Config;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.ValidatorConfig;
import com.networknt.status.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaSchemaValidator {
    static final Logger logger = LoggerFactory.getLogger(LambdaSchemaValidator.class);
    private static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static final String CONTENT_TYPE = "application/json";
    private static final String CONFIG_NAME = "openapi";
    private static final String SPEC_INJECT = "openapi-inject";
    public static ValidatorConfig config;
    public static OpenApiHelper helper;
    RequestValidator requestValidator;

    public LambdaSchemaValidator() {
        if (logger.isInfoEnabled()) {
            logger.info("LambdaSchemaValidator is constructed");
        }
        config = ValidatorConfig.load();
        Map inject = Config.getInstance().getJsonMapConfig(SPEC_INJECT);
        Map openapi = Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME);
        openapi = OpenApiHelper.merge((Map)openapi, (Map)inject);
        try {
            String openapiString = Config.getInstance().getMapper().writeValueAsString((Object)openapi);
            if (logger.isTraceEnabled()) {
                logger.trace("OpenApiMiddleware openapiString: " + openapiString);
            }
            helper = new OpenApiHelper(openapiString);
        }
        catch (JsonProcessingException e) {
            logger.error("merge specification failed");
            throw new RuntimeException("merge specification failed");
        }
        SchemaValidator schemaValidator = new SchemaValidator(LambdaSchemaValidator.helper.openApi3);
        this.requestValidator = new RequestValidator(schemaValidator, config);
    }

    public APIGatewayProxyResponseEvent validateRequest(APIGatewayProxyRequestEvent requestEvent) {
        String httpMethod;
        Optional maybeApiPath;
        NormalisedPath openApiPathString;
        Path path;
        Operation operation;
        if (logger.isTraceEnabled()) {
            logger.trace("validateRequest starts");
        }
        String reqPath = requestEvent.getPath();
        if (config.getSkipPathPrefixes() != null && config.getSkipPathPrefixes().stream().anyMatch(s -> reqPath.startsWith((String)s))) {
            if (logger.isDebugEnabled()) {
                logger.debug("validateRequest ends with skipped path {}", (Object)reqPath);
            }
            return null;
        }
        ApiNormalisedPath requestPath = new ApiNormalisedPath(reqPath, LambdaSchemaValidator.getBasePath(reqPath));
        if (logger.isTraceEnabled()) {
            logger.trace("requestPath original {} and normalized {}", (Object)requestPath.original(), (Object)requestPath.normalised());
        }
        if ((operation = (path = LambdaSchemaValidator.helper.openApi3.getPath((openApiPathString = (NormalisedPath)(maybeApiPath = helper.findMatchingApiPath((NormalisedPath)requestPath)).get()).original())).getOperation(httpMethod = requestEvent.getHttpMethod().toLowerCase())) == null) {
            Status status = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[]{httpMethod, openApiPathString.normalised()});
            return this.createErrorResponse(status.getStatusCode(), status.getCode(), status.getDescription());
        }
        OpenApiOperation openApiOperation = new OpenApiOperation(openApiPathString, path, httpMethod, operation);
        Status status = this.requestValidator.validateRequest((NormalisedPath)requestPath, requestEvent, openApiOperation);
        if (status != null) {
            return this.createErrorResponse(status.getStatusCode(), status.getCode(), status.getDescription());
        }
        return null;
    }

    private APIGatewayProxyResponseEvent createErrorResponse(int statusCode, String errorCode, String errorMessage) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", CONTENT_TYPE);
        String body = "{\"statusCode\":" + statusCode + ",\"code\":\"" + errorCode + ",\"description\":\"" + errorMessage + "\"}";
        if (logger.isDebugEnabled()) {
            logger.debug("error info:" + body);
        }
        return new APIGatewayProxyResponseEvent().withHeaders(headers).withStatusCode(Integer.valueOf(statusCode)).withBody(body);
    }

    public static String getBasePath(String requestPath) {
        String basePath = "";
        if (helper != null) {
            basePath = LambdaSchemaValidator.helper.basePath;
            if (logger.isTraceEnabled()) {
                logger.trace("Found basePath for single spec from OpenApiMiddleware helper: {}", (Object)basePath);
            }
        }
        return basePath;
    }
}

