/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.security.IJwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtVerifyHandler
implements MiddlewareHandler,
IJwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(JwtVerifyHandler.class);
    static final String HANDLER_CONFIG = "handler";
    static final String OPENAPI_SECURITY_CONFIG = "openapi-security";
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static SecurityConfig config = SecurityConfig.load((String)"openapi-security");
    public static JwtVerifier jwtVerifier;
    String basePath;
    private volatile HttpHandler next;

    public JwtVerifyHandler() {
        jwtVerifier = new JwtVerifier(config);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String reqPath = exchange.getRequestPath();
        if (config.getSkipPathPrefixes() != null && config.getSkipPathPrefixes().stream().anyMatch(s -> reqPath.startsWith((String)s))) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skip request path base on skipPathPrefixes for " + reqPath);
            }
            Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            return;
        }
        HashMap<String, Object> auditInfo = null;
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        if (logger.isTraceEnabled() && authorization != null) {
            logger.trace("Authorization header = " + authorization.substring(0, 20));
        }
        authorization = this.getScopeToken(authorization, headerMap);
        boolean ignoreExpiry = config.isIgnoreJwtExpiry();
        String jwt = JwtVerifier.getJwtFromAuthorization((String)authorization);
        if (jwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("parsed jwt from authorization = " + jwt.substring(0, 20));
            }
            try {
                JwtClaims claims = jwtVerifier.verifyJwt(jwt, ignoreExpiry, true, reqPath);
                if (logger.isTraceEnabled()) {
                    logger.trace("claims = " + claims.toJson());
                }
                if ((auditInfo = (HashMap<String, Object>)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
                    auditInfo = new HashMap<String, Object>();
                    exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                }
                String clientId = claims.getStringClaimValue("client_id");
                String userId = claims.getStringClaimValue("user_id");
                if (clientId == null) {
                    clientId = claims.getStringClaimValue("cid");
                }
                if (userId == null) {
                    userId = claims.getStringClaimValue("uid");
                }
                auditInfo.put("user_id", userId);
                auditInfo.put("subject_claims", claims);
                auditInfo.put("client_id", clientId);
                if (!config.isEnableH2c() && this.checkForH2CRequest(headerMap)) {
                    this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                    return;
                }
                String callerId = headerMap.getFirst(HttpStringConstants.CALLER_ID);
                if (callerId != null) {
                    auditInfo.put("caller_id", callerId);
                }
                if (config != null && config.isEnableVerifyScope()) {
                    ArrayList<String> secondaryScopes;
                    OpenApiOperation openApiOperation;
                    Operation operation;
                    if (logger.isTraceEnabled()) {
                        logger.trace("verify scope from the primary token when enableVerifyScope is true");
                    }
                    if ((operation = this.getOperation(exchange, openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation"), auditInfo)) == null) {
                        return;
                    }
                    String scopeHeader = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
                    String scopeJwt = JwtVerifier.getJwtFromAuthorization((String)scopeHeader);
                    if (!this.hasValidSecondaryScopes(exchange, scopeJwt, secondaryScopes = new ArrayList<String>(), ignoreExpiry, reqPath, auditInfo)) {
                        return;
                    }
                    if (!this.hasValidScope(exchange, scopeHeader, secondaryScopes, claims, operation)) {
                        return;
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("complete JWT verification for request path = " + exchange.getRequestURI());
                }
                Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            }
            catch (InvalidJwtException e) {
                logger.error("InvalidJwtException: ", (Throwable)e);
                this.setExchangeStatus(exchange, STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", (Throwable)e);
                this.setExchangeStatus(exchange, STATUS_AUTH_TOKEN_EXPIRED, new Object[0]);
            }
        } else {
            this.setExchangeStatus(exchange, STATUS_MISSING_AUTH_TOKEN, new Object[0]);
        }
    }

    protected String getScopeToken(String authorization, HeaderMap headerMap) {
        String returnToken = authorization;
        if (returnToken != null && !returnToken.startsWith("Bearer ")) {
            returnToken = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
            if (logger.isTraceEnabled() && returnToken != null) {
                logger.trace("The replaced authorization from X-Scope-Token header = " + returnToken.substring(0, 20));
            }
        }
        return returnToken;
    }

    protected boolean checkForH2CRequest(HeaderMap headerMap) {
        return headerMap.getFirst(Headers.UPGRADE) != null && headerMap.getFirst(Headers.CONNECTION) != null && headerMap.getFirst(Headers.CONNECTION).equalsIgnoreCase("upgrade");
    }

    protected Operation getOperation(HttpServerExchange exchange, OpenApiOperation openApiOperation, Map<String, Object> auditInfo) {
        Operation operation;
        if (openApiOperation == null) {
            String httpMethod;
            ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), this.basePath);
            Optional maybeApiPath = OpenApiHandler.getHelper((String)exchange.getRequestPath()).findMatchingApiPath((NormalisedPath)requestPath);
            if (maybeApiPath.isEmpty()) {
                this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[0]);
                return null;
            }
            NormalisedPath swaggerPathString = (NormalisedPath)maybeApiPath.get();
            Path swaggerPath = OpenApiHandler.getHelper((String)exchange.getRequestPath()).openApi3.getPath(swaggerPathString.original());
            operation = swaggerPath.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
            if (operation == null) {
                this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[]{httpMethod, swaggerPathString.normalised()});
                return null;
            }
            openApiOperation = new OpenApiOperation(swaggerPathString, swaggerPath, httpMethod, operation);
            auditInfo.put("openapi_operation", openApiOperation);
            auditInfo.put("endpoint", swaggerPathString.normalised() + "@" + httpMethod);
        } else {
            operation = openApiOperation.getOperation();
        }
        return operation;
    }

    protected boolean hasValidSecondaryScopes(HttpServerExchange exchange, String scopeJwt, List<String> secondaryScopes, boolean ignoreExpiry, String reqPath, Map<String, Object> auditInfo) {
        if (scopeJwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("start verifying scope token = " + scopeJwt.substring(0, 20));
            }
            try {
                JwtClaims scopeClaims = jwtVerifier.verifyJwt(scopeJwt, ignoreExpiry, true, reqPath);
                Object scopeClaim = scopeClaims.getClaimValue("scope");
                if (scopeClaim instanceof String) {
                    secondaryScopes.addAll(Arrays.asList(scopeClaims.getStringClaimValue("scope").split(" ")));
                } else if (scopeClaim instanceof List) {
                    secondaryScopes.addAll(scopeClaims.getStringListClaimValue("scope"));
                }
                if (secondaryScopes.isEmpty()) {
                    Object scpClaim = scopeClaims.getClaimValue("scp");
                    if (scpClaim instanceof String) {
                        secondaryScopes.addAll(Arrays.asList(scopeClaims.getStringClaimValue("scp").split(" ")));
                    } else if (scpClaim instanceof List) {
                        secondaryScopes.addAll(scopeClaims.getStringListClaimValue("scp"));
                    }
                }
                auditInfo.put("scope_client_id", scopeClaims.getStringClaimValue("client_id"));
                auditInfo.put("access_claims", scopeClaims);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                logger.error("InvalidJwtException", e);
                this.setExchangeStatus(exchange, STATUS_INVALID_SCOPE_TOKEN, new Object[0]);
                return false;
            }
            catch (ExpiredTokenException e) {
                logger.error("ExpiredTokenException", (Throwable)e);
                this.setExchangeStatus(exchange, STATUS_SCOPE_TOKEN_EXPIRED, new Object[0]);
                return false;
            }
        }
        return true;
    }

    protected boolean hasValidScope(HttpServerExchange exchange, String scopeHeader, List<String> secondaryScopes, JwtClaims claims, Operation operation) {
        if (config.isEnableVerifyScope()) {
            List specScopes = null;
            List securityRequirements = operation.getSecurityRequirements();
            if (securityRequirements != null) {
                for (SecurityRequirement requirement : securityRequirements) {
                    String oauth2Name;
                    SecurityParameter securityParameter = null;
                    Iterator iterator = OpenApiHandler.getHelper((String)exchange.getRequestPath()).oauth2Names.iterator();
                    while (iterator.hasNext() && (securityParameter = requirement.getRequirement(oauth2Name = (String)iterator.next())) == null) {
                    }
                    if (securityParameter != null) {
                        specScopes = securityParameter.getParameters();
                    }
                    if (specScopes == null) continue;
                    break;
                }
            }
            if (scopeHeader != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with scope token");
                }
                if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                    this.setExchangeStatus(exchange, STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, new Object[]{secondaryScopes, specScopes});
                    return false;
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with primary token");
                }
                List primaryScopes = null;
                try {
                    Object scopeClaim = claims.getClaimValue("scope");
                    if (scopeClaim instanceof String) {
                        primaryScopes = Arrays.asList(claims.getStringClaimValue("scope").split(" "));
                    } else if (scopeClaim instanceof List) {
                        primaryScopes = claims.getStringListClaimValue("scope");
                    }
                    if (primaryScopes == null || primaryScopes.isEmpty()) {
                        Object scpClaim = claims.getClaimValue("scp");
                        if (scpClaim instanceof String) {
                            primaryScopes = Arrays.asList(claims.getStringClaimValue("scp").split(" "));
                        } else if (scpClaim instanceof List) {
                            primaryScopes = claims.getStringListClaimValue("scp");
                        }
                    }
                }
                catch (MalformedClaimException e) {
                    logger.error("MalformedClaimException", (Throwable)e);
                    this.setExchangeStatus(exchange, STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                    return false;
                }
                if (!this.matchedScopes(primaryScopes, specScopes)) {
                    this.setExchangeStatus(exchange, STATUS_AUTH_TOKEN_SCOPE_MISMATCH, new Object[]{primaryScopes, specScopes});
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchedScopes(List<String> jwtScopes, Collection<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (jwtScopes != null && jwtScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!jwtScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnableVerifyJwt();
    }

    public void register() {
        ModuleRegistry.registerModule((String)JwtVerifyHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(OPENAPI_SECURITY_CONFIG), null);
    }

    public void reload() {
        config.reload(OPENAPI_SECURITY_CONFIG);
    }

    public JwtVerifier getJwtVerifier() {
        return jwtVerifier;
    }
}

