/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.security.AbstractSimpleJwtVerifyHandler;
import com.networknt.security.JwtVerifier;
import com.networknt.security.SecurityConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJwtVerifyHandler
extends AbstractSimpleJwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(SimpleJwtVerifyHandler.class);
    String basePath;

    public SimpleJwtVerifyHandler() {
        config = SecurityConfig.load();
        jwtVerifier = new JwtVerifier(config);
        HandlerConfig handlerConfig = HandlerConfig.load();
        this.basePath = handlerConfig == null ? "/" : handlerConfig.getBasePath();
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnableVerifyJwt();
    }

    public void register() {
        ModuleRegistry.registerModule((String)"security", (String)SimpleJwtVerifyHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("security"), null);
    }

    public void reload() {
        config.reload();
        jwtVerifier = new JwtVerifier(config);
        ModuleRegistry.registerModule((String)"security", (String)SimpleJwtVerifyHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("security"), null);
    }
}

