/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.security.AbstractSwtVerifyHandler;
import com.networknt.security.SecurityConfig;
import com.networknt.security.SwtVerifier;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtVerifyHandler
extends AbstractSwtVerifyHandler {
    static final Logger logger = LoggerFactory.getLogger(SwtVerifyHandler.class);
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    String basePath;

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnableVerifySwt();
    }

    public void register() {
        ModuleRegistry.registerModule((String)"security", (String)SwtVerifyHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("security"), null);
    }

    public void reload() {
        config.reload();
        ModuleRegistry.registerModule((String)"security", (String)SwtVerifyHandler.class.getName(), (Map)Config.getNoneDecryptedInstance().getJsonMapConfigNoCache("security"), null);
    }

    public List<String> getSpecScopes(HttpServerExchange exchange, Map<String, Object> auditInfo) throws Exception {
        OpenApiOperation openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation");
        Operation operation = this.getOperation(exchange, openApiOperation, auditInfo);
        if (operation == null) {
            if (config.isSkipVerifyScopeWithoutSpec()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SwtVerifyHandler.handleRequest ends without verifying scope due to spec.");
                }
                Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            }
            return null;
        }
        List specScopes = null;
        List securityRequirements = operation.getSecurityRequirements();
        if (securityRequirements != null) {
            for (SecurityRequirement requirement : securityRequirements) {
                String oauth2Name;
                SecurityParameter securityParameter = null;
                Iterator iterator = OpenApiHandler.getHelper((String)exchange.getRequestPath()).oauth2Names.iterator();
                while (iterator.hasNext() && (securityParameter = requirement.getRequirement(oauth2Name = (String)iterator.next())) == null) {
                }
                if (securityParameter != null) {
                    specScopes = securityParameter.getParameters();
                }
                if (specScopes == null) continue;
                break;
            }
        }
        return specScopes;
    }

    protected Operation getOperation(HttpServerExchange exchange, OpenApiOperation openApiOperation, Map<String, Object> auditInfo) {
        Operation operation;
        if (openApiOperation == null) {
            String httpMethod;
            Optional maybeApiPath;
            ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), this.basePath);
            OpenApiHelper helper = OpenApiHandler.getHelper((String)exchange.getRequestPath());
            Optional optional = maybeApiPath = helper == null ? Optional.empty() : helper.findMatchingApiPath((NormalisedPath)requestPath);
            if (maybeApiPath.isEmpty()) {
                if (!config.isSkipVerifyScopeWithoutSpec()) {
                    this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[0]);
                }
                return null;
            }
            NormalisedPath swaggerPathString = (NormalisedPath)maybeApiPath.get();
            Path swaggerPath = OpenApiHandler.getHelper((String)exchange.getRequestPath()).openApi3.getPath(swaggerPathString.original());
            operation = swaggerPath.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
            if (operation == null) {
                this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[]{httpMethod, swaggerPathString.normalised()});
                exchange.endExchange();
                return null;
            }
            openApiOperation = new OpenApiOperation(swaggerPathString, swaggerPath, httpMethod, operation);
            auditInfo.put("openapi_operation", openApiOperation);
            auditInfo.put("endpoint", swaggerPathString.normalised() + "@" + httpMethod);
        } else {
            operation = openApiOperation.getOperation();
        }
        return operation;
    }

    public SwtVerifyHandler() {
        config = SecurityConfig.load();
        swtVerifier = new SwtVerifier(config);
        HandlerConfig handlerConfig = HandlerConfig.load();
        this.basePath = handlerConfig == null ? "/" : handlerConfig.getBasePath();
    }
}

