/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.config.Config;
import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.Header;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Response;
import com.networknt.oas.model.Schema;
import com.networknt.oas.model.impl.SchemaImpl;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorHandler;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseValidator {
    private final SchemaValidator schemaValidator = new SchemaValidator(OpenApiHelper.openApi3);
    private final SchemaValidatorsConfig config;
    private static final String VALIDATOR_RESPONSE_CONTENT_UNEXPECTED = "ERR11018";
    private static final String REQUIRED_RESPONSE_HEADER_MISSING = "ERR11019";
    private static final String JSON_MEDIA_TYPE = "application/json";
    private static final String GOOD_STATUS_CODE = "200";
    private static final String DEFAULT_STATUS_CODE = "default";
    private static final Logger logger = LoggerFactory.getLogger(ResponseValidator.class);

    public ResponseValidator(SchemaValidatorsConfig config) {
        this.config = config;
    }

    public ResponseValidator() {
        this.config = new SchemaValidatorsConfig();
    }

    public Status validateResponseContent(Object responseContent, HttpServerExchange exchange) {
        return this.validateResponseContent(responseContent, exchange.getRequestURI(), exchange.getRequestMethod().toString().toLowerCase(), String.valueOf(exchange.getStatusCode()));
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod) {
        return this.validateResponseContent(responseContent, uri, httpMethod, GOOD_STATUS_CODE);
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod, String statusCode) {
        return this.validateResponseContent(responseContent, uri, httpMethod, statusCode, JSON_MEDIA_TYPE);
    }

    public Status validateResponseContent(Object responseContent, String uri, String httpMethod, String statusCode, String mediaTypeName) {
        OpenApiOperation operation = null;
        try {
            operation = this.getOpenApiOperation(uri, httpMethod);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{httpMethod, uri});
        }
        if (operation == null) {
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{httpMethod, uri});
        }
        return this.validateResponseContent(responseContent, operation, statusCode, mediaTypeName);
    }

    public Status validateResponseContent(Object responseContent, OpenApiOperation openApiOperation, String statusCode, String mediaTypeName) {
        JsonNode schema;
        if (responseContent instanceof String) {
            responseContent = this.convertStrToObjTree((String)responseContent);
        }
        if ((schema = this.getContentSchema(openApiOperation, statusCode, mediaTypeName)) == null || schema.isMissingNode()) {
            if (openApiOperation.getOperation().getResponses().containsKey(String.valueOf(statusCode))) {
                return null;
            }
            schema = this.getContentSchema(openApiOperation, DEFAULT_STATUS_CODE, mediaTypeName);
            if (schema == null || schema.isMissingNode()) {
                return null;
            }
        }
        if (responseContent != null && schema == null || responseContent == null && schema != null) {
            return new Status(VALIDATOR_RESPONSE_CONTENT_UNEXPECTED, new Object[]{openApiOperation.getMethod(), openApiOperation.getPathString().original()});
        }
        this.config.setTypeLoose(false);
        this.config.setHandleNullableField(ValidatorHandler.config.isHandleNullableField());
        return this.schemaValidator.validate(responseContent, schema, this.config);
    }

    private Object convertStrToObjTree(String s) {
        Object contentObj;
        block5: {
            contentObj = null;
            if (s != null) {
                s = s.trim();
                try {
                    if (s.startsWith("{")) {
                        contentObj = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        break block5;
                    }
                    if (s.startsWith("[")) {
                        contentObj = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<Object>>(){});
                        break block5;
                    }
                    logger.error("cannot deserialize json str: {}", (Object)s);
                    return null;
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return contentObj;
    }

    private OpenApiOperation getOpenApiOperation(String uri, String httpMethod) throws URISyntaxException {
        String uriWithoutQuery = new URI(uri).getPath();
        ApiNormalisedPath requestPath = new ApiNormalisedPath(uriWithoutQuery);
        Optional maybeApiPath = OpenApiHelper.getInstance().findMatchingApiPath((NormalisedPath)requestPath);
        if (!maybeApiPath.isPresent()) {
            return null;
        }
        NormalisedPath openApiPathString = (NormalisedPath)maybeApiPath.get();
        Path path = OpenApiHelper.openApi3.getPath(openApiPathString.original());
        Operation operation = path.getOperation(httpMethod);
        return new OpenApiOperation(openApiPathString, path, httpMethod, operation);
    }

    private JsonNode getContentSchema(OpenApiOperation operation, String statusCode, String mediaTypeStr) {
        Optional<MediaType> mediaType;
        Optional<Response> response = Optional.ofNullable(operation.getOperation().getResponse(String.valueOf(statusCode)));
        if (response.isPresent() && (mediaType = Optional.ofNullable(response.get().getContentMediaType(mediaTypeStr))).isPresent()) {
            Schema schema = mediaType.get().getSchema();
            JsonNode schemaNode = schema == null ? null : Overlay.toJson((JsonOverlay)((SchemaImpl)schema));
            return schemaNode;
        }
        return null;
    }

    public Status validateResponse(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(openApiOperation, "An OpenAPI operation is required");
        String statusCode = String.valueOf(exchange.getStatusCode());
        Status status = this.validateHeaders(exchange, openApiOperation, statusCode);
        if (status != null) {
            return status;
        }
        byte[] responseBody = (byte[])exchange.getAttachment(StoreResponseStreamSinkConduit.RESPONSE);
        String mediaType = exchange.getResponseHeaders().get(Headers.CONTENT_TYPE) == null ? "" : exchange.getResponseHeaders().get(Headers.CONTENT_TYPE).getFirst();
        String body = responseBody == null ? null : new String(responseBody);
        status = this.validateResponseContent((Object)body, openApiOperation, statusCode, mediaType);
        return status;
    }

    private Status validateHeaders(HttpServerExchange exchange, OpenApiOperation operation, String statusCode) {
        Map headerMap;
        Optional<Status> optional;
        Optional<Response> response = Optional.ofNullable(operation.getOperation().getResponse(statusCode));
        if (response.isPresent() && (optional = (headerMap = response.get().getHeaders()).entrySet().stream().filter(entry -> !"Content-Type".equals(entry.getKey())).map(p -> this.validateHeader(exchange, (String)p.getKey(), (Header)p.getValue())).filter(s -> s != null).findFirst()).isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Status validateHeader(HttpServerExchange exchange, String headerName, Header operationHeader) {
        HeaderValues headerValues = exchange.getResponseHeaders().get(headerName);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(true);
        config.setHandleNullableField(ValidatorHandler.config.isHandleNullableField());
        if (headerValues == null || headerValues.isEmpty()) {
            if (Boolean.TRUE.equals(operationHeader.getRequired())) {
                return new Status(REQUIRED_RESPONSE_HEADER_MISSING, new Object[]{headerName});
            }
        } else {
            Optional<Status> optional = headerValues.stream().map(v -> this.schemaValidator.validate(v, Overlay.toJson((JsonOverlay)((SchemaImpl)operationHeader.getSchema())), config)).filter(s -> s != null).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return null;
    }
}

