/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.body.BodyHandler;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.RequestBody;
import com.networknt.oas.model.impl.RequestBodyImpl;
import com.networknt.oas.model.impl.SchemaImpl;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorHandler;
import com.networknt.openapi.parameter.ParameterType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.status.Status;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    static final Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    static final String VALIDATOR_REQUEST_BODY_UNEXPECTED = "ERR11013";
    static final String VALIDATOR_REQUEST_BODY_MISSING = "ERR11014";
    static final String VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING = "ERR11017";
    static final String VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING = "ERR11000";
    private final SchemaValidator schemaValidator;

    public RequestValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
    }

    public Status validateRequest(NormalisedPath requestPath, HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Objects.requireNonNull(requestPath, "A request path is required");
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(openApiOperation, "An OpenAPI operation is required");
        Status status = this.validateRequestParameters(exchange, requestPath, openApiOperation);
        if (status != null) {
            return status;
        }
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null || contentType.startsWith("application/json")) {
            Object body = exchange.getAttachment(BodyHandler.REQUEST_BODY);
            if (body == null && ValidatorHandler.config.skipBodyValidation) {
                return null;
            }
            status = this.validateRequestBody(body, openApiOperation);
        }
        return status;
    }

    private Status validateRequestBody(Object requestBody, OpenApiOperation openApiOperation) {
        RequestBody specBody = openApiOperation.getOperation().getRequestBody();
        if (requestBody != null && specBody == null) {
            return new Status(VALIDATOR_REQUEST_BODY_UNEXPECTED, new Object[]{openApiOperation.getMethod(), openApiOperation.getPathString().original()});
        }
        if (specBody == null || !Overlay.isPresent((JsonOverlay)((RequestBodyImpl)specBody))) {
            return null;
        }
        if (requestBody == null) {
            if (specBody.getRequired() != null && specBody.getRequired().booleanValue()) {
                if (BodyHandler.config.isEnabled()) {
                    return new Status(VALIDATOR_REQUEST_BODY_MISSING, new Object[]{openApiOperation.getMethod(), openApiOperation.getPathString().original()});
                }
                logger.warn("Body object doesn't exist in exchange attachment. Most likely the BodyHandler is not in the request chain before RequestValidator or reqeust misses application/json content type header");
            }
            return null;
        }
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(false);
        config.setHandleNullableField(ValidatorHandler.config.isHandleNullableField());
        return this.schemaValidator.validate(requestBody, Overlay.toJson((JsonOverlay)((SchemaImpl)specBody.getContentMediaType("application/json").getSchema())), config, "requestBody");
    }

    private Status validateRequestParameters(HttpServerExchange exchange, NormalisedPath requestPath, OpenApiOperation openApiOperation) {
        Status status = this.validatePathParameters(exchange, requestPath, openApiOperation);
        if (status != null) {
            return status;
        }
        status = this.validateQueryParameters(exchange, openApiOperation);
        if (status != null) {
            return status;
        }
        status = this.validateHeaderParameters(exchange, openApiOperation);
        if (status != null) {
            return status;
        }
        status = this.validateCookieParameters(exchange, openApiOperation);
        if (status != null) {
            return status;
        }
        return null;
    }

    private Status validatePathParameters(HttpServerExchange exchange, NormalisedPath requestPath, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getOperation().getParameters(), ParameterType.PATH);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return result.getStatus();
        }
        Status status = null;
        for (int i = 0; i < openApiOperation.getPathString().parts().size(); ++i) {
            if (!openApiOperation.getPathString().isParam(i)) continue;
            String paramName = openApiOperation.getPathString().paramName(i);
            Optional<Parameter> parameter = result.getSkippedParameters().stream().filter(p -> p.getName().equalsIgnoreCase(paramName)).findFirst();
            if (!parameter.isPresent()) continue;
            String paramValue = requestPath.part(i);
            try {
                paramValue = URLDecoder.decode(requestPath.part(i), "UTF-8");
            }
            catch (Exception e) {
                logger.info("Path parameter cannot be decoded, it will be used directly");
            }
            return this.schemaValidator.validate((Object)paramValue, Overlay.toJson((JsonOverlay)((SchemaImpl)parameter.get().getSchema())), paramName);
        }
        return status;
    }

    private Status validateQueryParameters(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getOperation().getParameters(), ParameterType.QUERY);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return result.getStatus();
        }
        Optional<Status> optional = result.getSkippedParameters().stream().map(p -> this.validateQueryParameter(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
        return optional.orElse(null);
    }

    private Status validateQueryParameter(HttpServerExchange exchange, OpenApiOperation openApiOperation, Parameter queryParameter) {
        Collection queryParameterValues = (Collection)exchange.getQueryParameters().get(queryParameter.getName());
        if (queryParameterValues == null || queryParameterValues.isEmpty()) {
            if (queryParameter.getRequired() != null && queryParameter.getRequired().booleanValue()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_QUERY_MISSING, new Object[]{queryParameter.getName(), openApiOperation.getPathString().original()});
            }
        } else {
            if (queryParameterValues.size() < 2) {
                Optional<Status> optional = queryParameterValues.stream().map(v -> this.schemaValidator.validate(v, Overlay.toJson((JsonOverlay)((SchemaImpl)queryParameter.getSchema())), queryParameter.getName())).filter(s -> s != null).findFirst();
                return optional.orElse(null);
            }
            return this.schemaValidator.validate((Object)queryParameterValues, Overlay.toJson((JsonOverlay)((SchemaImpl)queryParameter.getSchema())), queryParameter.getName());
        }
        return null;
    }

    private Status validateHeaderParameters(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Optional<Status> optional = this.validatePathLevelHeaders(exchange, openApiOperation);
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = this.validateOperationLevelHeaders(exchange, openApiOperation);
        return optional.orElse(null);
    }

    private Optional<Status> validatePathLevelHeaders(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getPathObject().getParameters(), ParameterType.HEADER);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return Optional.ofNullable(result.getStatus());
        }
        return result.getSkippedParameters().stream().map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
    }

    private Optional<Status> validateOperationLevelHeaders(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getOperation().getParameters(), ParameterType.HEADER);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return Optional.ofNullable(result.getStatus());
        }
        return result.getSkippedParameters().stream().map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
    }

    private Status validateCookieParameters(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        Optional<Status> optional = this.validatePathLevelCookies(exchange, openApiOperation);
        if (optional.isPresent()) {
            return optional.get();
        }
        optional = this.validateOperationLevelCookies(exchange, openApiOperation);
        return optional.orElse(null);
    }

    private Optional<Status> validatePathLevelCookies(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getPathObject().getParameters(), ParameterType.COOKIE);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return Optional.ofNullable(result.getStatus());
        }
        return result.getSkippedParameters().stream().map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
    }

    private Optional<Status> validateOperationLevelCookies(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        ValidationResult result = this.validateDeserializedValues(exchange, openApiOperation.getOperation().getParameters(), ParameterType.COOKIE);
        if (null != result.getStatus() || result.getSkippedParameters().isEmpty()) {
            return Optional.ofNullable(result.getStatus());
        }
        return result.getSkippedParameters().stream().map(p -> this.validateHeader(exchange, openApiOperation, (Parameter)p)).filter(s -> s != null).findFirst();
    }

    private Status validateHeader(HttpServerExchange exchange, OpenApiOperation openApiOperation, Parameter headerParameter) {
        HeaderValues headerValues = exchange.getRequestHeaders().get(new HttpString(headerParameter.getName()));
        if (headerValues == null || headerValues.isEmpty()) {
            if (headerParameter.getRequired().booleanValue()) {
                return new Status(VALIDATOR_REQUEST_PARAMETER_HEADER_MISSING, new Object[]{headerParameter.getName(), openApiOperation.getPathString().original()});
            }
        } else {
            Optional<Status> optional = headerValues.stream().map(v -> this.schemaValidator.validate(v, Overlay.toJson((JsonOverlay)((SchemaImpl)headerParameter.getSchema())), headerParameter.getName())).filter(s -> s != null).findFirst();
            return optional.orElse(null);
        }
        return null;
    }

    private ValidationResult validateDeserializedValues(HttpServerExchange exchange, Collection<Parameter> parameters, ParameterType type) {
        ValidationResult validationResult = new ValidationResult();
        parameters.stream().filter(p -> ParameterType.is((String)p.getIn(), (ParameterType)type)).forEach(p -> {
            Object deserializedValue = this.getDeserializedValue(exchange, p.getName(), type);
            if (null == deserializedValue) {
                validationResult.addSkipped((Parameter)p);
            } else {
                Status s = this.schemaValidator.validate(deserializedValue, Overlay.toJson((JsonOverlay)((SchemaImpl)p.getSchema())), p.getName());
                validationResult.addStatus(s);
            }
        });
        return validationResult;
    }

    private Object getDeserializedValue(HttpServerExchange exchange, String name, ParameterType type) {
        if (null != type && StringUtils.isNotBlank((CharSequence)name)) {
            switch (type) {
                case QUERY: {
                    return OpenApiHandler.getQueryParameters((HttpServerExchange)exchange, (boolean)true).get(name);
                }
                case PATH: {
                    return OpenApiHandler.getPathParameters((HttpServerExchange)exchange, (boolean)true).get(name);
                }
                case HEADER: {
                    return OpenApiHandler.getHeaderParameters((HttpServerExchange)exchange, (boolean)true).get(name);
                }
                case COOKIE: {
                    return OpenApiHandler.getCookieParameters((HttpServerExchange)exchange, (boolean)true).get(name);
                }
            }
        }
        return null;
    }

    class ValidationResult {
        private Set<Parameter> skippedParameters = new HashSet<Parameter>();
        private List<Status> statuses = new ArrayList<Status>();

        ValidationResult() {
        }

        public void addSkipped(Parameter p) {
            this.skippedParameters.add(p);
        }

        public void addStatus(Status s) {
            if (null != s) {
                this.statuses.add(s);
            }
        }

        public Set<Parameter> getSkippedParameters() {
            return Collections.unmodifiableSet(this.skippedParameters);
        }

        public Status getStatus() {
            return this.statuses.isEmpty() ? null : this.statuses.get(0);
        }

        public List<Status> getAllStatueses() {
            return Collections.unmodifiableList(this.statuses);
        }
    }
}

