/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.RequestValidator;
import com.networknt.openapi.ResponseValidator;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.conduits.StreamSinkConduit;

public class ValidatorHandler
implements MiddlewareHandler {
    public static final String OPENAPI_CONFIG_NAME = "openapi-validator";
    public static final String CONFIG_NAME = "validator";
    public static final String OPENAPI_YML_CONFIG = "openapi.yml";
    public static final String OPENAPI_YAML_CONFIG = "openapi.yaml";
    public static final String OPENAPI_JSON_CONFIG = "openapi.json";
    public static final String HANDLER_CONFIG_NAME = "handler";
    static final String STATUS_MISSING_OPENAPI_OPERATION = "ERR10012";
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    static ValidatorConfig config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig("openapi-validator", ValidatorConfig.class);
    private volatile HttpHandler next;
    RequestValidator requestValidator;
    ResponseValidator responseValidator;
    String basePath;

    public ValidatorHandler() {
        if (OpenApiHelper.getInstance() == null) {
            String spec = Config.getInstance().getStringFromFile(OPENAPI_YML_CONFIG);
            if (spec == null && (spec = Config.getInstance().getStringFromFile(OPENAPI_YAML_CONFIG)) == null) {
                spec = Config.getInstance().getStringFromFile(OPENAPI_JSON_CONFIG);
            }
            OpenApiHelper.init((String)spec);
        }
        SchemaValidator schemaValidator = new SchemaValidator(OpenApiHelper.openApi3);
        this.requestValidator = new RequestValidator(schemaValidator);
        this.responseValidator = new ResponseValidator();
        this.basePath = ((HandlerConfig)Config.getInstance().getJsonObjectConfig(HANDLER_CONFIG_NAME, HandlerConfig.class)).getBasePath();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), this.basePath);
        OpenApiOperation openApiOperation = null;
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null) {
            openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation");
        }
        if (openApiOperation == null) {
            this.setExchangeStatus(exchange, STATUS_MISSING_OPENAPI_OPERATION, new Object[0]);
            return;
        }
        Status status = this.requestValidator.validateRequest((NormalisedPath)requestPath, exchange, openApiOperation);
        if (status != null) {
            this.setExchangeStatus(exchange, status);
            if (ValidatorHandler.config.logError) {
                logger.error("There is an Validation Error:");
            }
            return;
        }
        if (ValidatorHandler.config.validateResponse) {
            this.validateResponse(exchange, openApiOperation);
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    private void validateResponse(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        exchange.addResponseWrapper((factory, exchange12) -> new StoreResponseStreamSinkConduit((StreamSinkConduit)factory.create(), exchange12));
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            Status status = this.responseValidator.validateResponse(exchange, openApiOperation);
            if (status != null) {
                logger.error("Response validation error: {} \n with response body: {}", (Object)status.getDescription(), (Object)new String((byte[])exchange.getAttachment(StoreResponseStreamSinkConduit.RESPONSE)));
            }
            nextListener.proceed();
        });
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(OPENAPI_CONFIG_NAME), null);
    }

    static {
        if (config == null) {
            config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ValidatorConfig.class);
        }
    }
}

