/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.config.Config;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.impl.OpenApi3Impl;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationMessage;
import com.networknt.status.Status;
import java.util.Objects;
import java.util.Set;

public class SchemaValidator {
    private static final String COMPONENTS_FIELD = "components";
    static final String VALIDATOR_SCHEMA_INVALID_JSON = "ERR11003";
    static final String VALIDATOR_SCHEMA = "ERR11004";
    private final OpenApi3 api;
    private JsonNode jsonNode;
    private final SchemaValidatorsConfig defaultConfig;

    public SchemaValidator() {
        this(null);
    }

    public SchemaValidator(OpenApi3 api) {
        this.api = api;
        this.jsonNode = Overlay.toJson((JsonOverlay)((OpenApi3Impl)api)).get(COMPONENTS_FIELD);
        this.defaultConfig = new SchemaValidatorsConfig();
        this.defaultConfig.setTypeLoose(true);
    }

    public Status validate(Object value, JsonNode schema, SchemaValidatorsConfig config) {
        return this.doValidate(value, schema, config);
    }

    public Status validate(Object value, JsonNode schema) {
        return this.doValidate(value, schema, this.defaultConfig);
    }

    private Status doValidate(Object value, JsonNode schema, SchemaValidatorsConfig config) {
        Objects.requireNonNull(schema, "A schema is required");
        Status status = null;
        Set processingReport = null;
        try {
            if (this.jsonNode != null) {
                ((ObjectNode)schema).set(COMPONENTS_FIELD, this.jsonNode);
            }
            JsonSchema jsonSchema = JsonSchemaFactory.getInstance().getSchema(schema, config);
            JsonNode content = Config.getInstance().getMapper().valueToTree(value);
            processingReport = jsonSchema.validate(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (processingReport != null && processingReport.size() > 0) {
            ValidationMessage vm = (ValidationMessage)processingReport.iterator().next();
            status = new Status(VALIDATOR_SCHEMA, new Object[]{vm.getMessage()});
        }
        return status;
    }
}

