/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorConfig {
    public static final String CONFIG_NAME = "openapi-validator";
    private static final Logger logger = LoggerFactory.getLogger(ValidatorConfig.class);
    private static final String ENABLED = "enabled";
    private static final String LOG_ERROR = "logError";
    private static final String SKIP_BODY_VALIDATION = "skipBodyValidation";
    private static final String VALIDATE_RESPONSE = "validateResponse";
    private static final String HANDLE_NULLABLE_FIELD = "handleNullableField";
    private static final String SKIP_PATH_PREFIXES = "skipPathPrefixes";
    private Map<String, Object> mappedConfig;
    private Config config = Config.getInstance();
    boolean enabled;
    boolean logError;
    boolean skipBodyValidation = false;
    boolean validateResponse;
    boolean handleNullableField = true;
    private List<String> skipPathPrefixes;

    private ValidatorConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    private ValidatorConfig() {
        this(CONFIG_NAME);
    }

    public static ValidatorConfig load(String configName) {
        return new ValidatorConfig(configName);
    }

    public static ValidatorConfig load() {
        return new ValidatorConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLogError() {
        return this.logError;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public boolean isSkipBodyValidation() {
        return this.skipBodyValidation;
    }

    public void setSkipBodyValidation(boolean skipBodyValidation) {
        this.skipBodyValidation = skipBodyValidation;
    }

    public boolean isValidateResponse() {
        return this.validateResponse;
    }

    public void setValidateResponse(boolean validateResponse) {
        this.validateResponse = validateResponse;
    }

    public boolean isHandleNullableField() {
        return this.handleNullableField;
    }

    public void setHandleNullableField(boolean handleNullableField) {
        this.handleNullableField = handleNullableField;
    }

    public List<String> getSkipPathPrefixes() {
        return this.skipPathPrefixes;
    }

    public void setSkipPathPrefixes(List<String> skipPathPrefixes) {
        this.skipPathPrefixes = skipPathPrefixes;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null && ((Boolean)object).booleanValue()) {
                this.enabled = true;
            }
            if ((object = this.getMappedConfig().get(LOG_ERROR)) != null && ((Boolean)object).booleanValue()) {
                this.logError = true;
            }
            if ((object = this.getMappedConfig().get(SKIP_BODY_VALIDATION)) != null && ((Boolean)object).booleanValue()) {
                this.skipBodyValidation = true;
            }
            if ((object = this.getMappedConfig().get(VALIDATE_RESPONSE)) != null && ((Boolean)object).booleanValue()) {
                this.validateResponse = true;
            }
            if ((object = this.getMappedConfig().get(HANDLE_NULLABLE_FIELD)) != null && ((Boolean)object).booleanValue()) {
                this.handleNullableField = true;
            }
        }
    }

    private void setConfigList() {
        if (this.mappedConfig != null && this.mappedConfig.get(SKIP_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(SKIP_PATH_PREFIXES);
            this.skipPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s = (String)object;
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("[")) {
                    try {
                        this.skipPathPrefixes = (List)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the skipPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.skipPathPrefixes = Arrays.asList(s.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.skipPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("skipPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

