/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.RequestValidator;
import com.networknt.openapi.ResponseValidator;
import com.networknt.openapi.SchemaValidator;
import com.networknt.openapi.ValidatorConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.conduits.StreamSinkConduit;

public class ValidatorHandler
implements MiddlewareHandler {
    public static final String OPENAPI_CONFIG_NAME = "openapi-validator";
    public static final String CONFIG_NAME = "validator";
    static final String STATUS_MISSING_OPENAPI_OPERATION = "ERR10012";
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    static ValidatorConfig config;
    private volatile HttpHandler next;
    RequestValidator requestValidator;
    Map<String, RequestValidator> requestValidatorMap;
    ResponseValidator responseValidator;
    Map<String, ResponseValidator> responseValidatorMap;

    public ValidatorHandler() {
        config = ValidatorConfig.load(OPENAPI_CONFIG_NAME);
        if (config == null) {
            config = ValidatorConfig.load(CONFIG_NAME);
        }
        if (OpenApiHandler.helper != null) {
            SchemaValidator schemaValidator = new SchemaValidator(OpenApiHandler.helper.openApi3);
            this.requestValidator = new RequestValidator(schemaValidator);
            this.responseValidator = new ResponseValidator(schemaValidator);
        } else {
            this.requestValidatorMap = new HashMap<String, RequestValidator>();
            this.responseValidatorMap = new HashMap<String, ResponseValidator>();
            for (Map.Entry entry : OpenApiHandler.helperMap.entrySet()) {
                SchemaValidator schemaValidator = new SchemaValidator(((OpenApiHelper)entry.getValue()).openApi3);
                RequestValidator reqV = new RequestValidator(schemaValidator);
                this.requestValidatorMap.put((String)entry.getKey(), reqV);
                ResponseValidator resV = new ResponseValidator(schemaValidator);
                this.responseValidatorMap.put((String)entry.getKey(), resV);
            }
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("ValidatorHandler.handleRequest starts.");
        }
        String reqPath = exchange.getRequestPath();
        if (config.getSkipPathPrefixes() != null && config.getSkipPathPrefixes().stream().anyMatch(s -> reqPath.startsWith((String)s))) {
            if (logger.isDebugEnabled()) {
                logger.debug("ValidatorHandler.handleRequest ends with skipped path " + reqPath);
            }
            Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
            return;
        }
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), OpenApiHandler.getBasePath((String)exchange.getRequestPath()));
        OpenApiOperation openApiOperation = null;
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null) {
            openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation");
        }
        if (openApiOperation == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ValidatorHandler.handleRequest ends with an error.");
            }
            this.setExchangeStatus(exchange, STATUS_MISSING_OPENAPI_OPERATION, new Object[0]);
            return;
        }
        RequestValidator reqV = this.getRequestValidator(exchange.getRequestPath());
        Status status = reqV.validateRequest((NormalisedPath)requestPath, exchange, openApiOperation);
        if (status != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ValidatorHandler.handleRequest ends with an error.");
            }
            this.setExchangeStatus(exchange, status);
            if (ValidatorHandler.config.logError) {
                logger.error("There is an Validation Error:");
            }
            return;
        }
        if (ValidatorHandler.config.validateResponse) {
            this.validateResponse(exchange, openApiOperation);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ValidatorHandler.handleRequest ends.");
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    private void validateResponse(HttpServerExchange exchange, OpenApiOperation openApiOperation) {
        exchange.addResponseWrapper((factory, exchange12) -> new StoreResponseStreamSinkConduit((StreamSinkConduit)factory.create(), exchange12));
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            ResponseValidator resV = this.getResponseValidator(exchange.getRequestPath());
            Status status = resV.validateResponse(exchange, openApiOperation);
            if (status != null) {
                logger.error("Response validation error: {} \n with response body: {}", (Object)status.getDescription(), (Object)new String((byte[])exchange.getAttachment(StoreResponseStreamSinkConduit.RESPONSE)));
            }
            nextListener.proceed();
        });
    }

    private RequestValidator getRequestValidator(String requestPath) {
        RequestValidator validator = null;
        if (this.requestValidator != null) {
            validator = this.requestValidator;
        } else {
            for (Map.Entry<String, RequestValidator> entry : this.requestValidatorMap.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                validator = entry.getValue();
                break;
            }
        }
        return validator;
    }

    private ResponseValidator getResponseValidator(String requestPath) {
        ResponseValidator validator = null;
        if (this.responseValidator != null) {
            validator = this.responseValidator;
        } else {
            for (Map.Entry<String, ResponseValidator> entry : this.responseValidatorMap.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                validator = entry.getValue();
                break;
            }
        }
        return validator;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), config.getMappedConfig(), null);
    }

    public void reload() {
        config.reload(OPENAPI_CONFIG_NAME);
        if (config == null) {
            config.reload(CONFIG_NAME);
        }
        ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), config.getMappedConfig(), null);
    }
}

