/*
 * Decompiled with CFR 0.152.
 */
package com.piro.bezier;

import com.piro.bezier.Vector2;
import eu.mihosoft.vrl.v3d.Vector3d;

public class Bezier {
    float length;
    float[] coord;

    public Bezier(float sx, float sy, float[] coords, int numCoords) {
        this.setCoords(sx, sy, coords, numCoords);
    }

    public void setCoords(float sx, float sy, float[] coords, int numCoords) {
        this.coord = new float[numCoords * 2 + 2];
        this.coord[0] = sx;
        this.coord[1] = sy;
        for (int i = 0; i < numCoords; ++i) {
            this.coord[i * 2 + 2] = coords[i * 2];
            this.coord[i * 2 + 3] = coords[i * 2 + 1];
        }
        this.calcLength();
    }

    public float getLength() {
        return this.length;
    }

    private void calcLength() {
        this.length = 0.0f;
        for (int i = 2; i < this.coord.length; i += 2) {
            this.length += this.lineLength(this.coord[i - 2], this.coord[i - 1], this.coord[i], this.coord[i + 1]);
        }
    }

    private float lineLength(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public Vector2 getFinalPoint(Vector2 point) {
        point.x = this.coord[this.coord.length - 2];
        point.y = this.coord[this.coord.length - 1];
        return point;
    }

    Vector3d eval(double param) {
        Vector2 point = new Vector2();
        point.x = 0.0f;
        point.y = 0.0f;
        int numKnots = this.coord.length / 2;
        for (int i = 0; i < numKnots; ++i) {
            double scale = this.bernstein(numKnots - 1, i, param);
            point.x = (float)((double)point.x + (double)this.coord[i * 2] * scale);
            point.y = (float)((double)point.y + (double)this.coord[i * 2 + 1] * scale);
        }
        return new Vector3d(point.x, point.y);
    }

    private double bernstein(int numKnots, int knotNo, double param) {
        int i;
        double iParam = 1.0 - param;
        switch (numKnots) {
            case 0: {
                return 1.0;
            }
            case 1: {
                switch (knotNo) {
                    case 0: {
                        return iParam;
                    }
                    case 1: {
                        return param;
                    }
                }
                break;
            }
            case 2: {
                switch (knotNo) {
                    case 0: {
                        return iParam * iParam;
                    }
                    case 1: {
                        return 2.0 * iParam * param;
                    }
                    case 2: {
                        return param * param;
                    }
                }
                break;
            }
            case 3: {
                switch (knotNo) {
                    case 0: {
                        return iParam * iParam * iParam;
                    }
                    case 1: {
                        return 3.0 * iParam * iParam * param;
                    }
                    case 2: {
                        return 3.0 * iParam * param * param;
                    }
                    case 3: {
                        return param * param * param;
                    }
                }
            }
        }
        double retVal = 1.0;
        for (i = 0; i < knotNo; ++i) {
            retVal *= param;
        }
        for (i = 0; i < numKnots - knotNo; ++i) {
            retVal *= iParam;
        }
        return retVal *= (double)this.choose(numKnots, knotNo);
    }

    private int choose(int num, int denom) {
        int i;
        int denom2 = num - denom;
        if (denom < denom2) {
            int tmp = denom;
            denom = denom2;
            denom2 = tmp;
        }
        int prod = 1;
        for (i = num; i > denom; --i) {
            prod *= num;
        }
        for (i = 2; i <= denom2; ++i) {
            prod /= i;
        }
        return prod;
    }
}

