/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import java.util.List;

public class ChamferedCube
extends Primitive {
    double w;
    double h;
    double d;
    double chamferHeight;
    private final PropertyStorage properties = new PropertyStorage();

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public ChamferedCube(double w, double h, double d, double chamferHeight) {
        this.w = w;
        this.h = h;
        this.d = d;
        this.chamferHeight = chamferHeight;
    }

    @Override
    public List<Polygon> toPolygons() {
        CSG cube1 = new Cube(this.w - this.chamferHeight * 2.0, this.h, this.d - this.chamferHeight * 2.0).toCSG();
        CSG cube2 = new Cube(this.w, this.h - this.chamferHeight * 2.0, this.d - this.chamferHeight * 2.0).toCSG();
        CSG cube3 = new Cube(this.w - this.chamferHeight * 2.0, this.h - this.chamferHeight * 2.0, this.d).toCSG();
        return cube1.union(cube2).union(cube3).hull().getPolygons();
    }
}

