/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.util.ArrayList;
import java.util.List;

public class Dodecahedron
extends Primitive {
    private Vector3d center;
    private double radius;
    private boolean centered = true;
    private final PropertyStorage properties = new PropertyStorage();

    public Dodecahedron() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.radius = 1.0;
    }

    public Dodecahedron(double size) {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.radius = size;
    }

    public Dodecahedron(Vector3d center, double size) {
        this.center = center;
        this.radius = size;
    }

    @Override
    public List<Polygon> toPolygons() {
        if (this.radius <= 0.0) {
            throw new NumberFormatException("radius can not be negative");
        }
        double phi = (Math.sqrt(5.0) + 1.0) / 2.0;
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        points.add(new Vector3d(-1.0, -1.0, -1.0));
        points.add(new Vector3d(-1.0, -1.0, 1.0));
        points.add(new Vector3d(-1.0, 1.0, -1.0));
        points.add(new Vector3d(-1.0, 1.0, 1.0));
        points.add(new Vector3d(1.0, -1.0, -1.0));
        points.add(new Vector3d(1.0, -1.0, 1.0));
        points.add(new Vector3d(1.0, 1.0, -1.0));
        points.add(new Vector3d(1.0, 1.0, 1.0));
        points.add(new Vector3d(0.0, 1.0 / phi, phi));
        points.add(new Vector3d(0.0, -1.0 / phi, phi));
        points.add(new Vector3d(phi, 0.0, 1.0 / phi));
        points.add(new Vector3d(1.0 / phi, phi, 0.0));
        points.add(new Vector3d(-1.0 / phi, phi, 0.0));
        points.add(new Vector3d(-phi, 0.0, 1.0 / phi));
        points.add(new Vector3d(1.0 / phi, -phi, 0.0));
        points.add(new Vector3d(phi, 0.0, -1.0 / phi));
        points.add(new Vector3d(0.0, 1.0 / phi, -phi));
        points.add(new Vector3d(-phi, 0.0, -1.0 / phi));
        points.add(new Vector3d(-1.0 / phi, -phi, 0.0));
        points.add(new Vector3d(0.0, -1.0 / phi, -phi));
        List<Polygon> polygons = HullUtil.hull(points).scale(this.radius * (phi - 1.0)).getPolygons();
        return polygons;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public Dodecahedron setCenter(Vector3d center) {
        this.center = center;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public Dodecahedron noCenter() {
        this.centered = false;
        return this;
    }
}

