/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Tuple3d;

public class Edge {
    private final Vertex p1;
    private final Vertex p2;
    private final Vector3d direction;
    public static final String KEY_POLYGON_HOLES = "jcsg:edge:polygon-holes";

    public Edge(Vertex p1, Vertex p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.direction = p2.pos.minus(p1.pos).normalized();
    }

    public Vertex getP1() {
        return this.p1;
    }

    public Vertex getP2() {
        return this.p2;
    }

    public static List<Edge> fromPolygon(Polygon poly) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (int i = 0; i < poly.vertices.size(); ++i) {
            Edge e = new Edge(poly.vertices.get(i), poly.vertices.get((i + 1) % poly.vertices.size()));
            result.add(e);
        }
        return result;
    }

    public static List<Vertex> toVertices(List<Edge> edges) {
        return edges.stream().map(e -> e.p1).collect(Collectors.toList());
    }

    public static List<Vector3d> toPoints(List<Edge> edges) {
        return edges.stream().map(e -> e.p1.pos).collect(Collectors.toList());
    }

    public static Polygon toPolygon(List<Vector3d> points, Plane plane) {
        Polygon p = Polygon.fromPoints(points);
        p.vertices.stream().forEachOrdered(vertex -> {
            vertex.normal = plane.normal.clone();
        });
        return p;
    }

    public static List<Polygon> toPolygons(List<Edge> boundaryEdges, Plane plane) {
        ArrayList<Vector3d> boundaryPath = new ArrayList<Vector3d>();
        boolean[] used = new boolean[boundaryEdges.size()];
        Edge edge = boundaryEdges.get(0);
        used[0] = true;
        while (true) {
            Edge finalEdge = edge;
            boundaryPath.add(finalEdge.p1.pos);
            int nextEdgeIndex = boundaryEdges.indexOf(boundaryEdges.stream().filter(e -> finalEdge.p2.equals(e.p1)).findFirst().get());
            if (used[nextEdgeIndex]) break;
            edge = boundaryEdges.get(nextEdgeIndex);
            used[nextEdgeIndex] = true;
        }
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        System.out.println("#bnd-path-length: " + boundaryPath.size());
        result.add(Edge.toPolygon(boundaryPath, plane));
        return result;
    }

    public static List<Polygon> boundaryPathsWithHoles(List<Polygon> boundaryPaths) {
        int i;
        List<Polygon> result = boundaryPaths.stream().map(p -> p.clone()).collect(Collectors.toList());
        ArrayList parents = new ArrayList();
        boolean[] isHole = new boolean[result.size()];
        for (int i2 = 0; i2 < result.size(); ++i2) {
            Polygon p1 = (Polygon)result.get(i2);
            ArrayList<Integer> parentsOfI = new ArrayList<Integer>();
            parents.add(parentsOfI);
            for (int j = 0; j < result.size(); ++j) {
                Polygon p2 = result.get(j);
                if (i2 == j || !p2.contains(p1)) continue;
                parentsOfI.add(j);
            }
            isHole[i2] = parentsOfI.size() % 2 != 0;
        }
        int[] parent = new int[result.size()];
        for (i = 0; i < parent.length; ++i) {
            parent[i] = -1;
        }
        for (i = 0; i < parents.size(); ++i) {
            ArrayList<Polygon> holes;
            List par = (List)parents.get(i);
            int max = 0;
            int maxIndex = 0;
            Iterator iterator = par.iterator();
            while (iterator.hasNext()) {
                int pIndex = (Integer)iterator.next();
                int pSize = ((List)parents.get(pIndex)).size();
                if (max >= pSize) continue;
                max = pSize;
                maxIndex = pIndex;
            }
            parent[i] = maxIndex;
            if (isHole[maxIndex] || !isHole[i]) continue;
            Optional holesOpt = result.get(maxIndex).getStorage().getValue(KEY_POLYGON_HOLES);
            if (holesOpt.isPresent()) {
                holes = (ArrayList<Polygon>)holesOpt.get();
            } else {
                holes = new ArrayList<Polygon>();
                result.get(maxIndex).getStorage().set(KEY_POLYGON_HOLES, holes);
            }
            holes.add(result.get(i));
        }
        return result;
    }

    public static List<Polygon> boundaryPaths(List<Edge> boundaryEdges) {
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        boolean[] used = new boolean[boundaryEdges.size()];
        int startIndex = 0;
        Edge edge = boundaryEdges.get(startIndex);
        used[startIndex] = true;
        startIndex = 1;
        while (startIndex > 0) {
            ArrayList<Vector3d> boundaryPath = new ArrayList<Vector3d>();
            while (true) {
                Edge nextEdge;
                int nextEdgeIndex;
                Edge finalEdge = edge;
                boundaryPath.add(finalEdge.p1.pos);
                Optional<Edge> nextEdgeResult = boundaryEdges.stream().filter(e -> finalEdge.p2.equals(e.p1)).findFirst();
                if (!nextEdgeResult.isPresent() || used[nextEdgeIndex = boundaryEdges.indexOf(nextEdge = nextEdgeResult.get())]) break;
                edge = nextEdge;
                used[nextEdgeIndex] = true;
            }
            if (boundaryPath.size() < 3) break;
            result.add(Polygon.fromPoints(boundaryPath));
            startIndex = Edge.nextUnused(used);
            if (startIndex <= 0) continue;
            edge = boundaryEdges.get(startIndex);
            used[startIndex] = true;
        }
        return result;
    }

    private static int nextUnused(boolean[] usage) {
        for (int i = 0; i < usage.length; ++i) {
            if (usage[i]) continue;
            return i;
        }
        return -1;
    }

    public static List<Polygon> _toPolygons(List<Edge> boundaryEdges, Plane plane) {
        ArrayList<Vector3d> boundaryPath = new ArrayList<Vector3d>();
        boolean[] used = new boolean[boundaryEdges.size()];
        Edge edge = boundaryEdges.get(0);
        used[0] = true;
        while (true) {
            Edge finalEdge = edge;
            boundaryPath.add(finalEdge.p1.pos);
            int nextEdgeIndex = boundaryEdges.indexOf(boundaryEdges.stream().filter(e -> finalEdge.p2.equals(e.p1)).findFirst().get());
            if (used[nextEdgeIndex]) break;
            edge = boundaryEdges.get(nextEdgeIndex);
            used[nextEdgeIndex] = true;
        }
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        System.out.println("#bnd-path-length: " + boundaryPath.size());
        result.add(Edge.toPolygon(boundaryPath, plane));
        return result;
    }

    public boolean colinear(Vector3d p) {
        return this.colinear(p, 1.0E-9);
    }

    public boolean colinear(Vector3d p, double TOL) {
        double x = p.x;
        double x1 = this.p1.pos.x;
        double x2 = this.p2.pos.x;
        double y = p.y;
        double y1 = this.p1.pos.y;
        double y2 = this.p2.pos.y;
        double z = p.z;
        double z1 = this.p1.pos.z;
        double z2 = this.p2.pos.z;
        double slopeSelfxy = (x1 - x2) / (y1 - y2);
        double slopeSelfxz = (x1 - x2) / (z1 - z2);
        double slopeSelfyz = (y1 - y2) / (z1 - z2);
        double slopeTestxy = (x - x2) / (y - y2);
        double slopeTestxz = (x - x2) / (z - z2);
        double slopeTestyz = (y - y2) / (z - z2);
        return Math.abs(slopeSelfxy - slopeTestxy) < TOL && Math.abs(slopeSelfxz - slopeTestxz) < TOL && Math.abs(slopeSelfyz - slopeTestyz) < TOL;
    }

    public boolean contains(Vector3d p, double TOL) {
        double PB;
        double AP;
        double x = p.x;
        double x1 = this.p1.pos.x;
        double x2 = this.p2.pos.x;
        double y = p.y;
        double y1 = this.p1.pos.y;
        double y2 = this.p2.pos.y;
        double z = p.z;
        double z2 = this.p2.pos.z;
        double z1 = this.p1.pos.z;
        double AB = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
        return Math.abs(AB - ((AP = Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1) + (z - z1) * (z - z1))) + (PB = Math.sqrt((x2 - x) * (x2 - x) + (y2 - y) * (y2 - y) + (z2 - z) * (z2 - z))))) < TOL;
    }

    public boolean contains(Vector3d p) {
        return this.contains(p, 1.0E-9);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.p1);
        hash = 71 * hash + Objects.hashCode(this.p2);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.p1.pos.test((Object)other.p1.pos, 1.0E-9) && this.p2.pos.test((Object)other.p2.pos, 1.0E-9)) {
            return true;
        }
        if (this.p1.pos.test((Object)other.p2.pos, 1.0E-9) && this.p2.pos.test((Object)other.p1.pos, 1.0E-9)) {
            return true;
        }
        if (!Objects.equals(this.p1, other.p1) && !Objects.equals(this.p2, other.p1)) {
            return false;
        }
        return Objects.equals(this.p2, other.p2) || Objects.equals(this.p1, other.p2);
    }

    public boolean isThisPointOneOfMine(Vertex test) {
        return this.p1.pos.test((Object)test.pos, 1.0E-9) || this.p2.pos.test((Object)test.pos, 1.0E-9);
    }

    public String toString() {
        return "[[" + this.p1.getX() + ", " + this.p1.getY() + ", " + this.p1.getZ() + "], [" + this.p2.getX() + ", " + this.p2.getY() + ", " + this.p2.getZ() + "]]";
    }

    public Vector3d getDirection() {
        return this.direction;
    }

    public Optional<Vector3d> getClosestPoint(Edge e) {
        double b;
        Vector3d eZero;
        Vector3d delta0;
        double a;
        Vector3d ourDir = this.getDirection();
        double cos = ourDir.dot(e.getDirection());
        double n = 1.0 - cos * cos;
        if (n < 1.0E-9) {
            return Optional.empty();
        }
        Vector3d thisDelta = this.p2.pos.minus(this.p1.pos);
        double norm2This = thisDelta.magnitudeSq();
        Vector3d eDelta = e.p2.pos.minus(e.p1.pos);
        double norm2E = eDelta.magnitudeSq();
        Vector3d thisZero = this.p1.pos.plus(thisDelta.times(-this.p1.pos.dot(thisDelta) / norm2This));
        Vector3d closestP = thisZero.plus(this.direction.times(((a = (delta0 = (eZero = e.p1.pos.plus(eDelta.times(-e.p1.pos.dot(eDelta) / norm2E))).minus(thisZero)).dot(this.direction)) - (b = delta0.dot(e.direction)) * cos) / n));
        if (!this.contains(closestP)) {
            if (closestP.minus(this.p1.pos).magnitudeSq() < closestP.minus(this.p2.pos).magnitudeSq()) {
                return Optional.of(this.p1.pos);
            }
            return Optional.of(this.p2.pos);
        }
        return Optional.of(closestP);
    }

    public Optional<Vector3d> getIntersection(Edge e) {
        Optional<Vector3d> closestPOpt = this.getClosestPoint(e);
        if (!closestPOpt.isPresent()) {
            return Optional.empty();
        }
        Vector3d closestP = closestPOpt.get();
        if (e.contains(closestP)) {
            return closestPOpt;
        }
        return Optional.empty();
    }

    public static List<Polygon> boundaryPolygons(CSG csg) {
        ArrayList<Polygon> result = new ArrayList<Polygon>();
        for (List<Polygon> polygonGroup : Edge.searchPlaneGroups(csg.getPolygons())) {
            result.addAll(Edge.boundaryPolygonsOfPlaneGroup(polygonGroup));
        }
        return result;
    }

    public static List<Edge> boundaryEdgesOfPlaneGroup(List<Polygon> planeGroup) {
        ArrayList edges = new ArrayList();
        Stream pStream = planeGroup.size() > 200 ? planeGroup.parallelStream() : planeGroup.stream();
        pStream.map(p -> Edge.fromPolygon(p)).forEach(pEdges -> edges.addAll(pEdges));
        Stream edgeStream = edges.size() > 200 ? edges.parallelStream() : edges.stream();
        ArrayList potentialBoundaryEdges = new ArrayList();
        edgeStream.forEachOrdered(e -> {
            int count = Collections.frequency(edges, e);
            if (count == 1) {
                potentialBoundaryEdges.add(e);
            }
        });
        Stream bndEdgeStream = potentialBoundaryEdges.size() > 200 ? potentialBoundaryEdges.parallelStream() : potentialBoundaryEdges.stream();
        List<Edge> realBndEdges = bndEdgeStream.filter(be -> edges.stream().filter(e -> Edge.falseBoundaryEdgeSharedWithOtherEdge(be, e)).count() == 0L).collect(Collectors.toList());
        return realBndEdges;
    }

    private static List<Polygon> boundaryPolygonsOfPlaneGroup(List<Polygon> planeGroup) {
        List<Polygon> polygons = Edge.boundaryPathsWithHoles(Edge.boundaryPaths(Edge.boundaryEdgesOfPlaneGroup(planeGroup)));
        System.out.println("polygons: " + polygons.size());
        ArrayList<Polygon> result = new ArrayList<Polygon>(polygons.size());
        for (Polygon p : polygons) {
            Optional holesOfPresult = p.getStorage().getValue(KEY_POLYGON_HOLES);
            if (!holesOfPresult.isPresent()) {
                result.add(p);
                continue;
            }
            result.addAll(PolygonUtil.concaveToConvex(p));
        }
        return result;
    }

    public static boolean falseBoundaryEdgeSharedWithOtherEdge(Edge fbe, Edge e) {
        boolean sharedEndPoints;
        boolean bl = sharedEndPoints = e.getP1().pos.equals((Tuple3d)fbe.getP1().pos) || e.getP1().pos.equals((Tuple3d)fbe.getP2().pos) || e.getP2().pos.equals((Tuple3d)fbe.getP1().pos) || e.getP2().pos.equals((Tuple3d)fbe.getP2().pos);
        if (sharedEndPoints) {
            return false;
        }
        return fbe.contains(e.getP1().pos) || fbe.contains(e.getP2().pos);
    }

    private static List<List<Polygon>> searchPlaneGroups(List<Polygon> polygons) {
        ArrayList<List<Polygon>> planeGroups = new ArrayList<List<Polygon>>();
        boolean[] used = new boolean[polygons.size()];
        System.out.println("#polys: " + polygons.size());
        for (int pOuterI = 0; pOuterI < polygons.size(); ++pOuterI) {
            if (used[pOuterI]) continue;
            Polygon pOuter = polygons.get(pOuterI);
            ArrayList<Polygon> otherPolysInPlane = new ArrayList<Polygon>();
            otherPolysInPlane.add(pOuter);
            for (int pInnerI = 0; pInnerI < polygons.size(); ++pInnerI) {
                Vector3d nInner;
                Vector3d nOuter;
                double angle;
                Polygon pInner = polygons.get(pInnerI);
                if (pOuter.equals(pInner) || !((angle = (nOuter = pOuter.plane.normal).angle(nInner = pInner.plane.normal)) < 0.01)) continue;
                otherPolysInPlane.add(pInner);
                used[pInnerI] = true;
                System.out.println("used: " + pOuterI + " -> " + pInnerI);
            }
            if (otherPolysInPlane.isEmpty()) continue;
            planeGroups.add(otherPolysInPlane);
        }
        return planeGroups;
    }

    public double length() {
        return this.p1.pos.minus(this.p2.pos).length();
    }

    private static class Node<T> {
        private Node parent;
        private final List<Node> children = new ArrayList<Node>();
        private final int index;
        private final T value;
        private boolean isHole;

        public Node(int index, T value) {
            this.index = index;
            this.value = value;
        }

        public void addChild(int index, T value) {
            this.children.add(new Node<T>(index, value));
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Node getParent() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.index;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.index == other.index;
        }

        public int distanceToRoot() {
            int dist = 0;
            Node pNode = this.getParent();
            while (pNode != null) {
                ++dist;
                pNode = this.getParent();
            }
            return dist;
        }

        public boolean isIsHole() {
            return this.isHole;
        }

        public void setIsHole(boolean isHole) {
            this.isHole = isHole;
        }
    }
}

