/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Vector3d;

public class Matrix3d {
    public double m11;
    public double m12;
    public double m13;
    public double m21;
    public double m22;
    public double m23;
    public double m31;
    public double m32;
    public double m33;
    public static final Matrix3d ZERO = new Matrix3d(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final Matrix3d UNITY = new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);

    public Matrix3d(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public String toString() {
        return "[" + this.m11 + ", " + this.m12 + ", " + this.m13 + "]\n[" + this.m21 + ", " + this.m22 + ", " + this.m23 + "]\n[" + this.m31 + ", " + this.m32 + ", " + this.m33 + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix3d other = (Matrix3d)obj;
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(other.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(other.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m13) != Double.doubleToLongBits(other.m13)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(other.m21)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m22) != Double.doubleToLongBits(other.m22)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m23) != Double.doubleToLongBits(other.m23)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m31) != Double.doubleToLongBits(other.m31)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m32) != Double.doubleToLongBits(other.m32)) {
            return false;
        }
        return Double.doubleToLongBits(this.m33) == Double.doubleToLongBits(other.m33);
    }

    public Matrix3d times(double a) {
        return new Matrix3d(this.m11 * a, this.m12 * a, this.m13 * a, this.m21 * a, this.m22 * a, this.m23 * a, this.m31 * a, this.m32 * a, this.m33 * a);
    }

    public Vector3d times(Vector3d a) {
        return new Vector3d(this.m11 * a.x + this.m12 * a.y + this.m13 * a.z, this.m21 * a.x + this.m22 * a.y + this.m23 * a.z, this.m31 * a.x + this.m32 * a.y + this.m33 * a.z);
    }
}

