/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.ISlice;
import eu.mihosoft.vrl.v3d.JavaFXInitializer;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Scale;

public class Slice {
    private static int maxRes = 3000;
    private static ISlice sliceEngine = new DefaultSliceImp();

    private static boolean isPolygonAtZero(Polygon polygon) {
        for (Vertex v : polygon.vertices) {
            if (Slice.isVertexAtZero(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVertexAtZero(Vertex vertex) {
        double SLICE_UPPER_BOUND = 0.001;
        double SLICE_LOWER_BOUND = -0.001;
        return vertex.getZ() < 0.001 && vertex.getZ() > -0.001;
    }

    public static List<Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
        try {
            if (DefaultSliceImp.class.isInstance(sliceEngine)) {
                try {
                    return Slice.sanatize(new DefaultSliceImp().slice(incoming, slicePlane, normalInsetDistance));
                }
                catch (IllegalStateException e) {
                    JavaFXInitializer.go();
                    return Slice.sanatize(new DefaultSliceImp().slice(incoming, slicePlane, normalInsetDistance));
                }
            }
            return Slice.sanatize(Slice.getSliceEngine().slice(incoming, slicePlane, normalInsetDistance));
        }
        catch (Throwable e) {
            return Slice.sanatize(incoming.getPolygons());
        }
    }

    private static List<Polygon> sanatize(List<Polygon> slice) {
        for (int i = 0; i < slice.size(); ++i) {
            boolean bad;
            Polygon me = slice.get(i);
            boolean bl = bad = !Extrude.isCCW(me);
            if (bad) {
                List<Vector3d> points = me.getPoints();
                ArrayList<Vector3d> result = new ArrayList<Vector3d>(points);
                Collections.reverse(result);
                me = Polygon.fromPoints(result);
            }
            slice.set(i, me);
        }
        return slice;
    }

    public static List<Polygon> slice(CSG incoming) {
        return Slice.slice(incoming, new Transform(), 0.0);
    }

    public static List<Polygon> slice(CSG incoming, double normalInsetDistance) {
        return Slice.slice(incoming, new Transform(), normalInsetDistance);
    }

    public static ISlice getSliceEngine() {
        return sliceEngine;
    }

    public static void setSliceEngine(ISlice sliceEngine) {
        Slice.sliceEngine = sliceEngine;
    }

    public static int getMaxRes() {
        return maxRes;
    }

    public static void setNumFacesInOffset(int numFacesInOffset) {
        CSG.setNumFacesInOffset(numFacesInOffset);
    }

    public static void setMaxRes(int mr) {
        maxRes = mr;
    }

    private static class DefaultSliceImp
    implements ISlice {
        double sizeinPixelSpace = 1500.0;
        HashMap<WritableImage, PixelReader> readers = new HashMap();
        ArrayList<int[]> usedPixels = new ArrayList();
        int minRes = 1000;
        private boolean done;

        private DefaultSliceImp() {
        }

        Object[] toPixMap(CSG slicePart) {
            List<Polygon> polys;
            boolean ratioOrentation;
            double ratio = slicePart.getTotalY() / slicePart.getTotalX();
            boolean bl = ratioOrentation = slicePart.getTotalX() > slicePart.getTotalY();
            if (ratioOrentation) {
                ratio = slicePart.getTotalX() / slicePart.getTotalY();
            }
            ratio = 1.0 / ratio;
            double mySize = slicePart.getTotalX() > slicePart.getTotalY() ? slicePart.getTotalX() : slicePart.getTotalY();
            double size = this.sizeinPixelSpace * (mySize / 200.0) * (double)((polys = slicePart.getPolygons()).size() / 300);
            if (size < (double)this.minRes) {
                size = this.minRes;
            }
            if (size > (double)Slice.getMaxRes()) {
                size = Slice.getMaxRes();
            }
            double xPix = size * (ratioOrentation ? 1.0 : ratio);
            double yPix = size * (!ratioOrentation ? 1.0 : ratio);
            double xOffset = slicePart.getMinX();
            double yOffset = slicePart.getMinY();
            double scaleX = slicePart.getTotalX() / xPix;
            double scaleY = slicePart.getTotalY() / yPix;
            double imageOffset = 180.0;
            double imageOffsetMotion = imageOffset * scaleX / 2.0;
            int imgx = (int)(xPix + imageOffset);
            int imgy = (int)(yPix + imageOffset);
            final WritableImage obj_img = new WritableImage(imgx, imgy);
            MeshView sliceMesh = slicePart.getMesh();
            sliceMesh.getTransforms().add((Object)javafx.scene.transform.Transform.translate((double)imageOffsetMotion, (double)imageOffsetMotion));
            AnchorPane anchor = new AnchorPane(new Node[]{sliceMesh});
            AnchorPane.setBottomAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setTopAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setRightAnchor((Node)sliceMesh, (Double)0.0);
            final Pane snapshotGroup = new Pane(new Node[]{anchor});
            snapshotGroup.prefHeight(yPix + imageOffset);
            snapshotGroup.prefWidth(xPix + imageOffset);
            snapshotGroup.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
            final SnapshotParameters snapshotParameters = new SnapshotParameters();
            snapshotParameters.setTransform((javafx.scene.transform.Transform)new Scale(1.0 / scaleX, 1.0 / scaleY));
            snapshotParameters.setDepthBuffer(true);
            snapshotParameters.setFill((Paint)Color.TRANSPARENT);
            this.done = false;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    snapshotGroup.snapshot(snapshotParameters, obj_img);
                    done = true;
                }
            };
            Platform.runLater((Runnable)r);
            while (!this.done) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return new Object[]{obj_img, scaleX, xOffset - imageOffsetMotion, scaleY, yOffset - imageOffsetMotion, imageOffsetMotion, imageOffset};
        }

        int[] toPixels(double absX, double absY, double xOff, double yOff, double scaleX, double scaleY) {
            return new int[]{(int)((absX - xOff) / scaleX), (int)((absY - yOff) / scaleY)};
        }

        boolean pixelBlack(double absX, double absY, WritableImage obj_img) {
            PixelReader pixelReader;
            if (this.readers.get(obj_img) == null) {
                this.readers.put(obj_img, obj_img.getPixelReader());
            }
            return (pixelReader = this.readers.get(obj_img)).getColor((int)absX, (int)absY).getOpacity() != 0.0;
        }

        boolean pixelEdge(double absX, double absY, WritableImage obj_img) {
            for (int i = -1; i < 2; ++i) {
                int x = (int)(absX + (double)i);
                for (int j = -1; j < 2; ++j) {
                    int y = (int)(absY + (double)j);
                    try {
                        if (this.pixelBlack(x, y, obj_img)) continue;
                        return true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
            if (Thread.interrupted()) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            ArrayList<Polygon> rawPolygons = new ArrayList<Polygon>();
            CSG finalPart = incoming.transformed(slicePlane.inverse()).toolOffset(normalInsetDistance);
            CSG planeCSG = finalPart.getBoundingBox().toZMin();
            planeCSG = planeCSG.intersect(planeCSG.toZMax().movez(1.0E-5));
            CSG slicePart = finalPart.intersect(planeCSG);
            for (Polygon p : slicePart.getPolygons()) {
                if (!Slice.isPolygonAtZero(p)) continue;
                rawPolygons.add(p);
            }
            Object[] parts = this.toPixMap(slicePart);
            WritableImage obj_img = (WritableImage)parts[0];
            double scaleX = (Double)parts[1];
            double xOffset = (Double)parts[2];
            double scaleY = (Double)parts[3];
            double yOffset = (Double)parts[4];
            ArrayList<Vector3d> points = new ArrayList<Vector3d>();
            for (Polygon p : rawPolygons) {
                for (Vertex vertex : p.vertices) {
                    points.add(vertex.pos);
                }
            }
            ArrayList<Polygon> polys = new ArrayList<Polygon>();
            ArrayList<int[]> pixelVersionOfPoints = new ArrayList<int[]>();
            for (Vector3d vector3d : points) {
                int[] pix = this.toPixels(vector3d.x, vector3d.y, xOffset, yOffset, scaleX, scaleY);
                if (!this.pixelEdge(pix[0], pix[1], obj_img)) continue;
                pixelVersionOfPoints.add(pix);
            }
            ArrayList<int[]> pixelVersionOfPointsFiltered = new ArrayList<int[]>();
            for (int[] d : pixelVersionOfPoints) {
                boolean testIt = false;
                for (int[] x : pixelVersionOfPointsFiltered) {
                    if (!this.withinAPix(x, d)) continue;
                    testIt = true;
                }
                if (testIt) continue;
                pixelVersionOfPointsFiltered.add(d);
            }
            pixelVersionOfPoints = pixelVersionOfPointsFiltered;
            int[] nArray = (int[])pixelVersionOfPoints.get(0);
            pixelVersionOfPoints.remove(0);
            int[] nextPoint = nArray;
            ArrayList<int[]> listOfPointsForThisPoly = new ArrayList<int[]>();
            listOfPointsForThisPoly.add(nArray);
            int lastSearchIndex = 0;
            while (!(pixelVersionOfPoints.size() <= 0 && listOfPointsForThisPoly.size() <= 0 || Thread.interrupted())) {
                int[] nArray2;
                void var25_24;
                Object[] results = this.searchNext(nextPoint, obj_img, lastSearchIndex);
                if (results == null) {
                    int[] nArray3;
                    listOfPointsForThisPoly.clear();
                    if (pixelVersionOfPoints.size() <= 0) break;
                    nextPoint = nArray3 = (int[])pixelVersionOfPoints.remove(0);
                    listOfPointsForThisPoly.clear();
                    listOfPointsForThisPoly.add(nextPoint);
                    continue;
                }
                nextPoint = (int[])results[0];
                lastSearchIndex = (Integer)results[1];
                ArrayList<int[]> toRemove = new ArrayList<int[]>();
                for (int[] nArray4 : pixelVersionOfPoints) {
                    if (!this.withinAPix(nextPoint, nArray4)) continue;
                    toRemove.add(nArray4);
                }
                if (toRemove.size() > 0) {
                    for (int[] nArray5 : toRemove) {
                        pixelVersionOfPoints.remove(nArray5);
                        listOfPointsForThisPoly.add(nArray5);
                    }
                    continue;
                }
                if (listOfPointsForThisPoly.size() <= 2 || !this.withinAPix(nextPoint, (int[])var25_24)) continue;
                ArrayList<Vector3d> p = new ArrayList<Vector3d>();
                for (int[] it : listOfPointsForThisPoly) {
                    p.add(new Vector3d((double)it[0] * scaleX + xOffset, (double)it[1] * scaleY + yOffset, 0.0));
                }
                Polygon polygon = Polygon.fromPoints(p);
                polys.add(polygon);
                listOfPointsForThisPoly.clear();
                if (pixelVersionOfPoints.size() <= 0) continue;
                nextPoint = nArray2 = (int[])pixelVersionOfPoints.remove(0);
                listOfPointsForThisPoly.add(nextPoint);
            }
            if (listOfPointsForThisPoly.size() > 0) {
                ArrayList<Vector3d> p = new ArrayList<Vector3d>();
                for (int[] it : listOfPointsForThisPoly) {
                    p.add(new Vector3d((double)it[0] * scaleX + xOffset, (double)it[1] * scaleY + yOffset, 0.0));
                }
                polys.add(Polygon.fromPoints(p));
            }
            this.readers.clear();
            this.usedPixels.clear();
            System.out.println("Slice took: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            return polys;
        }

        Object[] searchNext(int[] pixStart, WritableImage obj_img, int lastSearchIndex) {
            double index = 1.0;
            Object[] ret = this.searchNextDepth(pixStart, obj_img, index, lastSearchIndex);
            while (ret == null && index < 10.0 && !Thread.interrupted()) {
                ret = this.searchNextDepth(pixStart, obj_img, index += 0.5, 0);
            }
            return ret;
        }

        Object[] searchNextDepth(int[] pixStart, WritableImage obj_img, double searchSize, int lastSearchIndex) {
            int end;
            int searchArraySize;
            ArrayList<int[]> locations = new ArrayList<int[]>();
            double inc = Math.toDegrees(Math.atan2(1.0, searchSize));
            if (searchSize > 2.0) {
                for (double i = 0.0; i < 360.0 + inc; i += inc) {
                    int x = (int)Math.round(Math.cos(Math.toRadians(i)) * searchSize);
                    int y = (int)Math.round(Math.sin(Math.toRadians(i)) * searchSize);
                    locations.add(new int[]{pixStart[0] + x, pixStart[1] + y});
                }
            } else {
                int i = (int)(-searchSize);
                while ((double)i < searchSize + 1.0) {
                    locations.add(new int[]{(int)((double)pixStart[0] + searchSize), pixStart[1] + i});
                    ++i;
                }
                i = (int)(searchSize - 1.0);
                while ((double)i > -searchSize - 1.0) {
                    locations.add(new int[]{pixStart[0] + i, (int)((double)pixStart[1] + searchSize)});
                    --i;
                }
                i = (int)(searchSize - 1.0);
                while ((double)i > -searchSize - 1.0) {
                    locations.add(new int[]{(int)((double)pixStart[0] - searchSize), pixStart[1] + i});
                    --i;
                }
                i = (int)(-searchSize + 1.0);
                while ((double)i < searchSize + 1.0) {
                    locations.add(new int[]{pixStart[0] + i, (int)((double)pixStart[1] - searchSize)});
                    ++i;
                }
            }
            if (lastSearchIndex >= (searchArraySize = locations.size())) {
                lastSearchIndex = 0;
            }
            if ((end = lastSearchIndex - 1) < 0) {
                end = searchArraySize - 1;
            }
            int i = lastSearchIndex;
            while (i != end && !Thread.interrupted()) {
                int counterCW = i - 1;
                if (counterCW < 0) {
                    counterCW = searchArraySize - 1;
                }
                int[] ccw = (int[])locations.get(counterCW);
                int[] self = (int[])locations.get(i);
                boolean w = !this.pixelBlack(self[0], self[1], obj_img);
                boolean b = this.pixelBlack(ccw[0], ccw[1], obj_img);
                boolean useMe = true;
                for (int[] it : this.usedPixels) {
                    if (it[0] != self[0] || it[1] != self[1]) continue;
                    useMe = false;
                    break;
                }
                if (w && b && useMe) {
                    this.usedPixels.add(self);
                    return new Object[]{self, i};
                }
                i = i + 1 >= searchArraySize ? 0 : i + 1;
            }
            return null;
        }

        boolean withinAPix(int[] incoming, int[] out) {
            int pixSize = 2;
            for (int i = -pixSize; i < pixSize + 1; ++i) {
                int x = incoming[0] + i;
                for (int j = -pixSize; j < pixSize + 1; ++j) {
                    int y = incoming[1] + j;
                    if (x != out[0] || y != out[1]) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

