/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers;

import eu.mihosoft.vrl.v3d.ext.openjfx.importers.Importer;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.ImporterFinder;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ServiceLoader;
import javafx.animation.Timeline;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.util.Pair;

public final class Importer3D {
    public static String[] getSupportedFormatExtensionFilters() {
        return new String[]{"*.obj"};
    }

    public static Node load(String fileUrl) throws IOException {
        return Importer3D.load(fileUrl, false);
    }

    public static Node load(String fileUrl, boolean asPolygonMesh) throws IOException {
        return (Node)Importer3D.loadIncludingAnimation(fileUrl, asPolygonMesh).getKey();
    }

    public static Pair<Node, Timeline> loadIncludingAnimation(String fileUrl, boolean asPolygonMesh) throws IOException {
        int dot = fileUrl.lastIndexOf(46);
        if (dot <= 0) {
            throw new IOException("Unknown 3D file format, url missing extension [" + fileUrl + "]");
        }
        String extension = fileUrl.substring(dot + 1, fileUrl.length()).toLowerCase();
        ImporterFinder finder = new ImporterFinder();
        URLClassLoader classLoader = finder.addUrlToClassPath();
        ServiceLoader<Importer> servantLoader = ServiceLoader.load(Importer.class, classLoader);
        Importer importer = null;
        for (Importer plugin : servantLoader) {
            if (!plugin.isSupported(extension)) continue;
            importer = plugin;
            break;
        }
        if (importer == null && !extension.equals("fxml")) {
            String[] names = new String[]{"com.javafx.experiments.importers.dae.DaeImporter", "com.javafx.experiments.importers.max.MaxLoader", "com.javafx.experiments.importers.maya.MayaImporter", "com.javafx.experiments.importers.obj.ObjOrPolyObjImporter"};
            boolean fail = true;
            for (String name : names) {
                try {
                    Importer plugin;
                    Class<?> clazz = Class.forName(name);
                    Object obj = clazz.newInstance();
                    if (!(obj instanceof Importer) || !(plugin = (Importer)obj).isSupported(extension)) continue;
                    importer = plugin;
                    fail = false;
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (fail) {
                throw new IOException("Unknown 3D file format [" + extension + "]");
            }
        }
        if (extension.equals("fxml")) {
            Object fxmlRoot = FXMLLoader.load((URL)new URL(fileUrl));
            if (fxmlRoot instanceof Node) {
                return new Pair((Object)((Node)fxmlRoot), null);
            }
            if (fxmlRoot instanceof TriangleMesh) {
                return new Pair((Object)new MeshView((Mesh)((TriangleMesh)fxmlRoot)), null);
            }
            throw new IOException("Unknown object in FXML file [" + fxmlRoot.getClass().getName() + "]");
        }
        importer.load(fileUrl, asPolygonMesh);
        return new Pair((Object)importer.getRoot(), (Object)importer.getTimeline());
    }
}

