/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javafx.scene.shape.TriangleMesh;
import javax.vecmath.Vector3f;

public class SmoothingGroups {
    private BitSet visited;
    private BitSet notVisited;
    private Queue<Integer> q;
    private int[][] faces;
    private int[][] faceNormals;
    private float[] normals;
    private Edge[][] faceEdges;
    private static final float normalAngle = 0.9994f;

    public SmoothingGroups(int[][] faces, int[][] faceNormals, float[] normals) {
        this.faces = faces;
        this.faceNormals = faceNormals;
        this.normals = normals;
        this.visited = new BitSet(faces.length);
        this.notVisited = new BitSet(faces.length);
        this.notVisited.set(0, faces.length, true);
        this.q = new LinkedList<Integer>();
    }

    private List<Integer> getNextConnectedComponent(Map<Edge, List<Integer>> adjacentFaces) {
        int index = this.notVisited.previousSetBit(this.faces.length - 1);
        this.q.add(index);
        this.visited.set(index);
        this.notVisited.set(index, false);
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (!this.q.isEmpty()) {
            Integer faceIndex = this.q.remove();
            res.add(faceIndex);
            for (Edge edge : this.faceEdges[faceIndex]) {
                Integer adjFaceIndex;
                List<Integer> adjFaces = adjacentFaces.get(edge);
                if (adjFaces == null || this.visited.get(adjFaceIndex = adjFaces.get(adjFaces.get(0).equals(faceIndex) ? 1 : 0))) continue;
                this.q.add(adjFaceIndex);
                this.visited.set(adjFaceIndex);
                this.notVisited.set((int)adjFaceIndex, false);
            }
        }
        return res;
    }

    private boolean hasNextConnectedComponent() {
        return !this.notVisited.isEmpty();
    }

    private void computeFaceEdges() {
        this.faceEdges = new Edge[this.faces.length][];
        for (int f = 0; f < this.faces.length; ++f) {
            int[] face = this.faces[f];
            int[] faceNormal = this.faceNormals[f];
            int n = face.length / 2;
            this.faceEdges[f] = new Edge[n];
            int from = face[(n - 1) * 2];
            int fromNormal = faceNormal[n - 1];
            for (int i = 0; i < n; ++i) {
                Edge edge;
                int to = face[i * 2];
                int toNormal = faceNormal[i];
                this.faceEdges[f][i] = edge = new Edge(from, to, fromNormal, toNormal);
                from = to;
                fromNormal = toNormal;
            }
        }
    }

    private Map<Edge, List<Integer>> getAdjacentFaces() {
        HashMap<Edge, List<Integer>> adjacentFaces = new HashMap<Edge, List<Integer>>();
        for (int f = 0; f < this.faceEdges.length; ++f) {
            for (Edge edge : this.faceEdges[f]) {
                if (!adjacentFaces.containsKey(edge)) {
                    adjacentFaces.put(edge, new ArrayList());
                }
                ((List)adjacentFaces.get(edge)).add(f);
            }
        }
        Iterator it = adjacentFaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (((List)e.getValue()).size() == 2) continue;
            it.remove();
        }
        return adjacentFaces;
    }

    Vector3f getNormal(int index) {
        return new Vector3f(this.normals[index * 3], this.normals[index * 3 + 1], this.normals[index * 3 + 2]);
    }

    private static boolean isNormalsEqual(Vector3f n1, Vector3f n2) {
        if (n1.x == 1.0E20f || n1.y == 1.0E20f || n1.z == 1.0E20f || n2.x == 1.0E20f || n2.y == 1.0E20f || n2.z == 1.0E20f) {
            return false;
        }
        Vector3f myN1 = new Vector3f(n1);
        myN1.normalize();
        Vector3f myN2 = new Vector3f(n2);
        myN2.normalize();
        return myN1.dot(myN2) >= 0.9994f;
    }

    private Map<Edge, List<Integer>> getSmoothEdges(Map<Edge, List<Integer>> adjacentFaces) {
        HashMap<Edge, List<Integer>> smoothEdges = new HashMap<Edge, List<Integer>>();
        for (int face = 0; face < this.faceEdges.length; ++face) {
            for (Edge edge : this.faceEdges[face]) {
                List<Integer> adjFaces = adjacentFaces.get(edge);
                if (adjFaces == null || adjFaces.size() != 2) continue;
                int adjFace = adjFaces.get(adjFaces.get(0) == face ? 1 : 0);
                Edge[] adjFaceEdges = this.faceEdges[adjFace];
                int adjEdgeInd = Arrays.asList(adjFaceEdges).indexOf(edge);
                if (adjEdgeInd == -1) {
                    System.out.println("Can't find edge " + edge + " in face " + adjFace);
                    System.out.println(Arrays.asList(adjFaceEdges));
                    continue;
                }
                Edge adjEdge = adjFaceEdges[adjEdgeInd];
                if (!edge.isSmooth(adjEdge) || smoothEdges.containsKey(edge)) continue;
                smoothEdges.put(edge, adjFaces);
            }
        }
        return smoothEdges;
    }

    private List<List<Integer>> calcConnComponents(Map<Edge, List<Integer>> smoothEdges) {
        ArrayList<List<Integer>> groups = new ArrayList<List<Integer>>();
        while (this.hasNextConnectedComponent()) {
            List<Integer> smoothGroup = this.getNextConnectedComponent(smoothEdges);
            groups.add(smoothGroup);
        }
        return groups;
    }

    private int[] generateSmGroups(List<List<Integer>> groups) {
        int[] smGroups = new int[this.faceNormals.length];
        int curGroup = 0;
        for (int i = 0; i < groups.size(); ++i) {
            List<Integer> list = groups.get(i);
            if (list.size() == 1) {
                smGroups[list.get((int)0).intValue()] = 0;
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                Integer faceIndex = list.get(j);
                smGroups[faceIndex.intValue()] = 1 << curGroup;
            }
            if (curGroup++ != 31) continue;
            curGroup = 0;
        }
        return smGroups;
    }

    private int[] calcSmoothGroups() {
        this.computeFaceEdges();
        Map<Edge, List<Integer>> adjacentFaces = this.getAdjacentFaces();
        Map<Edge, List<Integer>> smoothEdges = this.getSmoothEdges(adjacentFaces);
        List<List<Integer>> groups = this.calcConnComponents(smoothEdges);
        return this.generateSmGroups(groups);
    }

    public static int[] calcSmoothGroups(int[][] faces, int[][] faceNormals, float[] normals) {
        SmoothingGroups smoothGroups = new SmoothingGroups(faces, faceNormals, normals);
        return smoothGroups.calcSmoothGroups();
    }

    public static int[] calcSmoothGroups(TriangleMesh mesh, int[] flatFaces, int[] flatFaceNormals, float[] normals) {
        int faceElementSize = mesh.getFaceElementSize();
        int[][] faces = new int[flatFaces.length / faceElementSize][faceElementSize];
        for (int f = 0; f < faces.length; ++f) {
            for (int e = 0; e < faceElementSize; ++e) {
                faces[f][e] = flatFaces[f * faceElementSize + e];
            }
        }
        int pointElementSize = mesh.getPointElementSize();
        int[][] faceNormals = new int[flatFaceNormals.length / pointElementSize][pointElementSize];
        for (int f = 0; f < faceNormals.length; ++f) {
            for (int e = 0; e < pointElementSize; ++e) {
                faceNormals[f][e] = flatFaceNormals[f * pointElementSize + e];
            }
        }
        SmoothingGroups smoothGroups = new SmoothingGroups(faces, faceNormals, normals);
        return smoothGroups.calcSmoothGroups();
    }

    private class Edge {
        int from;
        int to;
        int fromNormal;
        int toNormal;

        public Edge(int from, int to, int fromNormal, int toNormal) {
            this.from = Math.min(from, to);
            this.to = Math.max(from, to);
            this.fromNormal = Math.min(fromNormal, toNormal);
            this.toNormal = Math.max(fromNormal, toNormal);
        }

        public boolean isSmooth(Edge edge) {
            boolean smooth = SmoothingGroups.isNormalsEqual(SmoothingGroups.this.getNormal(this.fromNormal), SmoothingGroups.this.getNormal(edge.fromNormal)) && SmoothingGroups.isNormalsEqual(SmoothingGroups.this.getNormal(this.toNormal), SmoothingGroups.this.getNormal(edge.toNormal)) || SmoothingGroups.isNormalsEqual(SmoothingGroups.this.getNormal(this.fromNormal), SmoothingGroups.this.getNormal(edge.toNormal)) && SmoothingGroups.isNormalsEqual(SmoothingGroups.this.getNormal(this.toNormal), SmoothingGroups.this.getNormal(edge.fromNormal));
            return smooth;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.from;
            hash = 41 * hash + this.to;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
    }
}

