/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic;

import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.PolygonMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.OriginalPointArray;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SymbolicPointArray;

public class SymbolicPolygonMesh {
    public SymbolicPointArray points;
    public float[] texCoords;
    public int[][] faces;
    public int[] faceSmoothingGroups;
    private int numEdgesInFaces = -1;

    public SymbolicPolygonMesh(SymbolicPointArray points, float[] texCoords, int[][] faces, int[] faceSmoothingGroups) {
        this.points = points;
        this.texCoords = texCoords;
        this.faces = faces;
        this.faceSmoothingGroups = faceSmoothingGroups;
    }

    public SymbolicPolygonMesh(PolygonMesh mesh) {
        this.points = new OriginalPointArray(mesh);
        this.texCoords = mesh.getTexCoords().toArray(this.texCoords);
        this.faces = mesh.faces;
        this.faceSmoothingGroups = mesh.getFaceSmoothingGroups().toArray(null);
    }

    public int getNumEdgesInFaces() {
        if (this.numEdgesInFaces == -1) {
            this.numEdgesInFaces = 0;
            for (int[] face : this.faces) {
                this.numEdgesInFaces += face.length;
            }
            this.numEdgesInFaces /= 2;
        }
        return this.numEdgesInFaces;
    }
}

