/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.quickhull3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.Point3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.QuickHull3D;
import java.util.ArrayList;
import java.util.List;

public class HullUtil {
    private HullUtil() {
        throw new AssertionError("Don't instantiate me!", null);
    }

    public static CSG hull(List<?> points) {
        ArrayList<Vector3d> plist = new ArrayList<Vector3d>();
        if (Vector3d.class.isInstance(points.get(0))) {
            points.stream().forEach(pobj -> plist.add((Vector3d)((Object)((Object)pobj))));
            return HullUtil.hull(plist, new PropertyStorage());
        }
        if (CSG.class.isInstance(points.get(0))) {
            for (Object csg : points) {
                ((CSG)csg).getPolygons().forEach(p -> p.vertices.forEach(v -> plist.add(v.pos)));
            }
            return HullUtil.hull(plist, new PropertyStorage());
        }
        throw new RuntimeException("Objects in list are of unknown type: " + points.get(0).getClass().getName() + "\r\nExpected CSG or Vector3d ");
    }

    public static CSG hull(List<Vector3d> points, PropertyStorage storage) {
        Point3d[] hullPoints = (Point3d[])points.stream().map(vec -> new Point3d(vec.x, vec.y, vec.z)).toArray(Point3d[]::new);
        QuickHull3D hull = new QuickHull3D();
        hull.build(hullPoints);
        hull.triangulate();
        int[][] faces = hull.getFaces();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ArrayList<Vector3d> vertices = new ArrayList<Vector3d>();
        int[][] nArray = faces;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] verts;
            for (int i2 : verts = nArray[i]) {
                vertices.add(points.get(hull.getVertexPointIndices()[i2]));
            }
            polygons.add(Polygon.fromPoints(vertices, storage));
            vertices.clear();
        }
        return CSG.fromPolygons(polygons);
    }

    public static CSG hull(CSG csg, PropertyStorage storage) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>(csg.getPolygons().size() * 3);
        csg.getPolygons().forEach(p -> p.vertices.forEach(v -> points.add(v.pos)));
        return HullUtil.hull(points, storage);
    }

    public static CSG hull(CSG ... csgList) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        for (CSG csg : csgList) {
            csg.getPolygons().forEach(p -> p.vertices.forEach(v -> points.add(v.pos)));
        }
        return HullUtil.hull(points, new PropertyStorage());
    }
}

