/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.floatpacket;

import edu.wpi.SimplePacketComs.PacketType;
import java.nio.ByteBuffer;

public class FloatPacketType
extends PacketType {
    public FloatPacketType(int id, int size) {
        super(id);
        this.packetSize = size;
        this.numberOfBytesPerValue = 4;
        this.numValues = this.packetSize / this.numberOfBytesPerValue - 4 / this.numberOfBytesPerValue;
        this.downstream = new Float[this.numValues];
        this.upstream = new Float[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            this.downstream[i] = Float.valueOf(0.0f);
            this.upstream[i] = Float.valueOf(0.0f);
        }
    }

    @Override
    public Number[] parse(byte[] bytes) {
        Number[] returnValues = new Number[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            int baseIndex = 4 * i + 4;
            returnValues[i] = Float.valueOf(ByteBuffer.wrap(bytes).order(be).getFloat(baseIndex));
        }
        return returnValues;
    }

    @Override
    public byte[] command(int idOfCommand, Number[] values) {
        byte[] message = new byte[this.packetSize];
        FloatPacketType.writeId(idOfCommand, message);
        for (int i = 0; i < this.numValues && i < values.length; ++i) {
            int baseIndex = 4 * i + 4;
            ByteBuffer.wrap(message).order(be).putFloat(baseIndex, ((Float)values[i]).floatValue()).array();
        }
        return message;
    }
}

