/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import edu.wpi.SimplePacketComs.PacketType;

public class FloatPacketType
extends PacketType {
    private final Number[] returnValues;
    private final byte[] message;

    public FloatPacketType(int id, int size) {
        super(id);
        packetSize = size;
        this.numberOfBytesPerValue = 4;
        this.numValues = packetSize / this.numberOfBytesPerValue - 4 / this.numberOfBytesPerValue;
        this.returnValues = new Number[this.numValues];
        this.message = new byte[packetSize];
        this.downstream = new Float[this.numValues];
        this.upstream = new Float[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            this.downstream[i] = Float.valueOf(0.0f);
            this.upstream[i] = Float.valueOf(0.0f);
        }
    }

    @Override
    public Number[] parse(byte[] bytes) {
        for (int i = 0; i < this.numValues; ++i) {
            int baseIndex = 4 * i + 4;
            int bits = this.toInt(bytes[0 + baseIndex]) | this.toInt(bytes[1 + baseIndex]) << 8 | this.toInt(bytes[2 + baseIndex]) << 16 | this.toInt(bytes[3 + baseIndex]) << 24;
            this.returnValues[i] = Float.valueOf(Float.intBitsToFloat(bits));
        }
        return this.returnValues;
    }

    int toInt(byte byteValue) {
        int val = byteValue;
        if (val < 0) {
            val += 256;
        }
        return val;
    }

    @Override
    public byte[] command(int idOfCommand, Number[] values) {
        FloatPacketType.writeId(idOfCommand, this.message);
        for (int i = 0; i < this.numValues && i < values.length; ++i) {
            int baseIndex = 4 * i + 4;
            int bits = Float.floatToIntBits(((Float)values[i]).floatValue());
            this.message[0 + baseIndex] = (byte)(bits & 0xFF);
            this.message[1 + baseIndex] = (byte)(bits >> 8 & 0xFF);
            this.message[2 + baseIndex] = (byte)(bits >> 16 & 0xFF);
            this.message[3 + baseIndex] = (byte)(bits >> 24 & 0xFF);
        }
        return this.message;
    }
}

