/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.device.warehouse;

import edu.wpi.SimplePacketComs.BytePacketType;
import edu.wpi.SimplePacketComs.FloatPacketType;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.device.UdpDevice;
import edu.wpi.SimplePacketComs.device.warehouse.WarehouseRobotStatus;
import edu.wpi.SimplePacketComs.phy.UDPSimplePacketComs;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javafx.scene.transform.Affine;

public class WarehouseRobot
extends UdpDevice {
    private PacketType estop = new BytePacketType(1989, 64);
    private PacketType getStatus = new BytePacketType(2012, 64);
    private PacketType clearFaults = new BytePacketType(1871, 64);
    private PacketType pickOrder = new FloatPacketType(1936, 64);
    private PacketType getLocation = new FloatPacketType(1994, 64);
    private PacketType directDrive = new FloatPacketType(1786, 64);
    private byte[] status = new byte[1];
    private double[] pickOrderData = new double[3];
    private double[] locationData = new double[8];
    private double[] driveData = new double[8];
    private double[] driveStatus = new double[1];
    private Affine locationAffine = new Affine();

    private WarehouseRobot(InetAddress add) throws Exception {
        super(add);
        for (PacketType pt : Arrays.asList(this.clearFaults, this.pickOrder, this.getStatus, this.directDrive, this.getLocation, this.estop)) {
            this.addPollingPacket(pt);
        }
        this.addEvent(this.getStatus.idOfCommand, new Runnable(){

            @Override
            public void run() {
                WarehouseRobot.this.readBytes(((WarehouseRobot)WarehouseRobot.this).getStatus.idOfCommand, WarehouseRobot.this.status);
            }
        });
        this.addEvent(this.directDrive.idOfCommand, new Runnable(){

            @Override
            public void run() {
                WarehouseRobot.this.readFloats(((WarehouseRobot)WarehouseRobot.this).directDrive.idOfCommand, WarehouseRobot.this.driveStatus);
            }
        });
        this.addEvent(this.getLocation.idOfCommand, new Runnable(){

            @Override
            public void run() {
                WarehouseRobot.this.readFloats(((WarehouseRobot)WarehouseRobot.this).getLocation.idOfCommand, WarehouseRobot.this.locationData);
                double rotationAngleRadians = Math.PI / 180 * WarehouseRobot.this.locationData[3];
                WarehouseRobot.this.getLocationAffine().setMxx(Math.cos(rotationAngleRadians));
                WarehouseRobot.this.getLocationAffine().setMxy(Math.sin(rotationAngleRadians));
                WarehouseRobot.this.getLocationAffine().setMxz(0.0);
                WarehouseRobot.this.getLocationAffine().setMyx(-Math.sin(rotationAngleRadians));
                WarehouseRobot.this.getLocationAffine().setMyy(Math.cos(rotationAngleRadians));
                WarehouseRobot.this.getLocationAffine().setMyz(0.0);
                WarehouseRobot.this.getLocationAffine().setMzx(0.0);
                WarehouseRobot.this.getLocationAffine().setMzy(0.0);
                WarehouseRobot.this.getLocationAffine().setMzz(1.0);
                WarehouseRobot.this.getLocationAffine().setTx(WarehouseRobot.this.locationData[0]);
                WarehouseRobot.this.getLocationAffine().setTy(WarehouseRobot.this.locationData[1]);
                WarehouseRobot.this.getLocationAffine().setTz(WarehouseRobot.this.locationData[2]);
            }
        });
        this.pickOrder.waitToSendMode();
        this.clearFaults.waitToSendMode();
        this.estop.waitToSendMode();
    }

    public static List<WarehouseRobot> get(String name) throws Exception {
        HashSet<InetAddress> addresses = UDPSimplePacketComs.getAllAddresses(name);
        ArrayList<WarehouseRobot> robots = new ArrayList<WarehouseRobot>();
        if (addresses.size() < 1) {
            System.out.println("No WarehouseRobot found named " + name);
            return robots;
        }
        for (InetAddress add : addresses) {
            System.out.println("Got " + add.getHostAddress());
            WarehouseRobot e = new WarehouseRobot(add);
            e.connect();
            robots.add(e);
        }
        return robots;
    }

    public static List<WarehouseRobot> get() throws Exception {
        return WarehouseRobot.get("Warehouse*");
    }

    public String toString() {
        return this.getName();
    }

    public List<Double> getLocationData() {
        ArrayList<Double> list = new ArrayList<Double>();
        return list;
    }

    public void estop() {
        this.estop.oneShotMode();
    }

    public double getDriveStatus() {
        return this.driveStatus[0];
    }

    public void pickOrder(double material, double angle, double dropLocation) {
        this.pickOrderData[0] = material;
        this.pickOrderData[1] = angle;
        this.pickOrderData[2] = dropLocation;
        this.writeFloats(this.pickOrder.idOfCommand, this.pickOrderData);
        this.pickOrder.oneShotMode();
    }

    public void directDrive(double deltaX, double deltaY, double deltaZ, double deltaAzimuth, double deltaElevation, double deltaTilt, double milisecondsTransition) throws Exception {
        if (this.getDriveStatus() < 0.9999) {
            // empty if block
        }
        this.driveData[0] = deltaX;
        this.driveData[1] = deltaY;
        this.driveData[2] = deltaZ;
        this.driveData[3] = deltaAzimuth;
        this.driveData[4] = deltaElevation;
        this.driveData[5] = deltaTilt;
        this.driveData[6] = milisecondsTransition;
        this.driveData[7] = Math.round(Math.random() * 100000.0);
        this.writeFloats(this.directDrive.idOfCommand, this.driveData);
    }

    public WarehouseRobotStatus getStatus() {
        return WarehouseRobotStatus.fromValue(this.status[0]);
    }

    public void clearFaults() {
        this.clearFaults.oneShotMode();
    }

    public Affine getLocationAffine() {
        return this.locationAffine;
    }

    public void setLocationAffine(Affine locationAffine) {
        this.locationAffine = locationAffine;
    }
}

