/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import edu.wpi.SimplePacketComs.BytePacketType;
import edu.wpi.SimplePacketComs.FloatPacketType;
import edu.wpi.SimplePacketComs.IPhysicalLayer;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.device.Device;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractSimpleComsDevice
implements Device,
IPhysicalLayer {
    HashMap<Integer, ArrayList<Runnable>> timeouts = new HashMap();
    HashMap<Integer, ArrayList<Runnable>> timeoutsToRemove = new HashMap();
    HashMap<Integer, ArrayList<Runnable>> events = new HashMap();
    HashMap<Integer, ArrayList<Runnable>> toRemove = new HashMap();
    boolean connected = false;
    ArrayList<PacketType> pollingQueue = new ArrayList();
    private boolean virtual = false;
    private String name = "SimpleComsDevice";
    private int readTimeout = 100;
    private boolean isTimedOut = false;

    @Override
    public abstract int read(byte[] var1, int var2);

    @Override
    public abstract int write(byte[] var1, int var2, int var3);

    @Override
    public abstract boolean disconnectDeviceImp();

    @Override
    public abstract boolean connectDeviceImp();

    public void addPollingPacket(PacketType packet) {
        if (this.getPacket(packet.idOfCommand) != null) {
            throw new RuntimeException("Only one packet of a given ID is allowed to poll. Add an event to recive data");
        }
        this.pollingQueue.add(packet);
    }

    public PacketType getPacket(Integer ID) {
        for (PacketType q : this.pollingQueue) {
            if (q.idOfCommand != ID) continue;
            return q;
        }
        return null;
    }

    public void removeEvent(Integer id, Runnable event) {
        if (this.toRemove.get(id) == null) {
            this.toRemove.put(id, new ArrayList());
        }
        this.toRemove.get(id).add(event);
    }

    public void addEvent(Integer id, Runnable event) {
        if (this.events.get(id) == null) {
            this.events.put(id, new ArrayList());
        }
        this.events.get(id).add(event);
    }

    public void removeTimeout(Integer id, Runnable event) {
        if (this.timeoutsToRemove.get(id) == null) {
            this.timeoutsToRemove.put(id, new ArrayList());
        }
        this.timeoutsToRemove.get(id).add(event);
    }

    public void addTimeout(Integer id, Runnable event) {
        if (this.timeouts.get(id) == null) {
            this.timeouts.put(id, new ArrayList());
        }
        this.timeouts.get(id).add(event);
    }

    public ArrayList<Integer> getIDs() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int j = 0; j < this.pollingQueue.size(); ++j) {
            PacketType pt = this.pollingQueue.get(j);
            ids.add(pt.idOfCommand);
        }
        return ids;
    }

    public void writeFloats(int id, double[] values) {
        if (this.getPacket(id) == null) {
            FloatPacketType pt = new FloatPacketType(id, 64);
            for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                pt.getDownstream()[i] = Float.valueOf((float)values[i]);
            }
            this.addPollingPacket(pt);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int j = 0; j < this.pollingQueue.size(); ++j) {
                PacketType pt = this.pollingQueue.get(j);
                if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
                for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                    pt.getDownstream()[i] = Float.valueOf((float)values[i]);
                }
                return;
            }
        }
    }

    public void writeBytes(int id, byte[] values) {
        if (this.getPacket(id) == null) {
            BytePacketType pt = new BytePacketType(id, 64);
            for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                pt.getDownstream()[i] = values[i];
            }
            this.addPollingPacket(pt);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int j = 0; j < this.pollingQueue.size(); ++j) {
                PacketType pt = this.pollingQueue.get(j);
                if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
                for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                    pt.getDownstream()[i] = values[i];
                }
                return;
            }
        }
    }

    public void writeFloats(Integer id, Double[] values) {
        this.writeFloats(id, values, true);
    }

    public void writeFloats(Integer id, Double[] values, Boolean polling) {
        if (this.getPacket(id) == null) {
            FloatPacketType pt = new FloatPacketType(id, 64);
            if (!polling.booleanValue()) {
                pt.oneShotMode();
            }
            for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                pt.getDownstream()[i] = Float.valueOf(values[i].floatValue());
            }
            this.addPollingPacket(pt);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int j = 0; j < this.pollingQueue.size(); ++j) {
                PacketType pt = this.pollingQueue.get(j);
                if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
                for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                    pt.getDownstream()[i] = Float.valueOf(values[i].floatValue());
                }
                if (!polling.booleanValue()) {
                    pt.oneShotMode();
                }
                return;
            }
        }
    }

    public void writeBytes(Integer id, Byte[] values) {
        this.writeBytes(id, values, true);
    }

    public void writeBytes(Integer id, Byte[] values, Boolean polling) {
        if (this.getPacket(id) == null) {
            BytePacketType pt = new BytePacketType(id, 64);
            if (!polling.booleanValue()) {
                pt.oneShotMode();
            }
            for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                pt.getDownstream()[i] = (byte)values[i];
            }
            this.addPollingPacket(pt);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int j = 0; j < this.pollingQueue.size(); ++j) {
                PacketType pt = this.pollingQueue.get(j);
                if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
                for (int i = 0; i < pt.getDownstream().length && i < values.length; ++i) {
                    pt.getDownstream()[i] = (byte)values[i];
                }
                if (!polling.booleanValue()) {
                    pt.oneShotMode();
                }
                return;
            }
        }
    }

    public Double[] readFloats(Integer id) {
        if (this.getPacket(id) == null) {
            this.addPollingPacket(new FloatPacketType(id, 64));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PacketType pt = this.getPacket(id);
        Double[] values = new Double[pt.getUpstream().length];
        for (int i = 0; i < pt.getUpstream().length && i < values.length; ++i) {
            values[i] = pt.getUpstream()[i].doubleValue();
        }
        return values;
    }

    public Byte[] readBytes(Integer id) {
        if (this.getPacket(id) == null) {
            this.addPollingPacket(new BytePacketType(id, 64));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PacketType pt = this.getPacket(id);
        Byte[] values = new Byte[pt.getUpstream().length];
        for (int i = 0; i < pt.getUpstream().length && i < values.length; ++i) {
            values[i] = pt.getUpstream()[i].byteValue();
        }
        return values;
    }

    public void readFloats(int id, double[] values) {
        if (this.getPacket(id) == null) {
            this.addPollingPacket(new FloatPacketType(id, 64));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int j = 0; j < this.pollingQueue.size(); ++j) {
            PacketType pt = this.pollingQueue.get(j);
            if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.getUpstream().length && i < values.length; ++i) {
                float d = ((Float)pt.getUpstream()[i]).floatValue();
                values[i] = d;
            }
            return;
        }
    }

    public void readBytes(int id, byte[] values) {
        if (this.getPacket(id) == null) {
            this.addPollingPacket(new BytePacketType(id, 64));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int j = 0; j < this.pollingQueue.size(); ++j) {
            PacketType pt = this.pollingQueue.get(j);
            if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.getUpstream().length && i < values.length; ++i) {
                values[i] = (Byte)pt.getUpstream()[i];
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(PacketType packet) {
        packet.started = true;
        try {
            block26: {
                if (!this.isVirtual()) {
                    try {
                        byte[] message = packet.command(packet.idOfCommand, packet.getDownstream());
                        int val = this.write(message, message.length, 1);
                        if (val <= 0) {
                            return;
                        }
                        int read = this.read(message, this.getReadTimeout());
                        if (read < packet.getUpstream().length) {
                            this.isTimedOut = true;
                            return;
                        }
                        int ID = PacketType.getId(message);
                        if (ID == packet.idOfCommand) {
                            if (this.isTimedOut) {
                                System.out.println("Timout resolved " + ID);
                            }
                            this.isTimedOut = false;
                            Number[] up = packet.parse(message);
                            for (int i = 0; i < packet.getUpstream().length; ++i) {
                                packet.getUpstream()[i] = up[i];
                            }
                        } else {
                            int i = 0;
                            while (true) {
                                if (i >= 3) {
                                    System.out.println(" ");
                                    this.isTimedOut = true;
                                    return;
                                }
                                this.read(message, this.getReadTimeout());
                                ++i;
                            }
                        }
                        ArrayList<Runnable> toRem = this.timeoutsToRemove.get(packet.idOfCommand);
                        if (toRem == null) break block26;
                        if (toRem.size() > 0) {
                            for (Runnable e : this.timeoutsToRemove.get(packet.idOfCommand)) {
                                this.timeouts.get(packet.idOfCommand).remove(e);
                            }
                            toRem.clear();
                        }
                        if (!this.isTimedOut) break block26;
                        for (Runnable e : this.timeouts.get(packet.idOfCommand)) {
                            if (e == null) continue;
                            try {
                                e.run();
                            }
                            catch (Throwable t) {
                                t.printStackTrace(System.out);
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                        this.disconnect();
                    }
                } else {
                    for (int j = 0; j < packet.getDownstream().length && j < packet.getUpstream().length; ++j) {
                        packet.getUpstream()[j] = packet.getDownstream()[j];
                    }
                }
            }
            if (!this.isTimedOut && this.events.get(packet.idOfCommand) != null) {
                if (this.toRemove.get(packet.idOfCommand) != null && this.toRemove.get(packet.idOfCommand).size() > 0) {
                    for (Runnable e : this.toRemove.get(packet.idOfCommand)) {
                        this.events.get(packet.idOfCommand).remove(e);
                    }
                    this.toRemove.get(packet.idOfCommand).clear();
                }
                for (Runnable e : this.events.get(packet.idOfCommand)) {
                    if (e == null) continue;
                    try {
                        e.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        packet.done = true;
    }

    private int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public boolean connect() {
        if (this.connectDeviceImp()) {
            this.setVirtual(false);
        } else {
            this.setVirtual(true);
        }
        this.connected = true;
        new Thread(){

            @Override
            public void run() {
                while (AbstractSimpleComsDevice.this.connected) {
                    try {
                        for (int i = 0; i < AbstractSimpleComsDevice.this.pollingQueue.size(); ++i) {
                            PacketType pollingPacket = AbstractSimpleComsDevice.this.pollingQueue.get(i);
                            if (!pollingPacket.sendOk()) continue;
                            AbstractSimpleComsDevice.this.process(pollingPacket);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        AbstractSimpleComsDevice.this.connected = false;
                    }
                }
                AbstractSimpleComsDevice.this.disconnectDeviceImp();
                System.out.println("SimplePacketComs disconnect");
            }
        }.start();
        return true;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }
}

