/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Items;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.DefaultCreator;
import com.ning.api.client.access.impl.DefaultDeleter;
import com.ning.api.client.access.impl.DefaultLister;
import com.ning.api.client.access.impl.PagedListImpl;
import com.ning.api.client.action.Creator;
import com.ning.api.client.action.Deleter;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpRequest;
import com.ning.api.client.item.Comment;
import com.ning.api.client.item.CommentField;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.Key;

public class Comments
extends Items<Comment, CommentField> {
    public Comments(NingConnection connection, NingClientConfig config) {
        super(connection, config, "Comment", Comment.class, CommentField.class);
    }

    public final Deleter<Comment> deleter(Key<Comment> id) {
        return new DefaultDeleter<Comment>(this.connection, this.config, this.endpointForDELETE(), id);
    }

    public Lister listerForRecent(Key<?> attachedTo, CommentField firstField, CommentField ... otherFields) {
        return this.listerForRecent(attachedTo, new Fields(CommentField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public Lister listerForRecent(Key<?> attachedTo, Fields<CommentField> fields) {
        return new Lister(this.connection, this.config, this.endpointForRecent(), fields, null, attachedTo);
    }

    public Creator<Comment> creator(Comment comment) {
        return new CommentCreator(this.connection, this.config, this.endpointForPOST(), comment);
    }

    protected static NingHttpRequest.Param attachedToParam(Key<?> attachedTo) {
        return new NingHttpRequest.Param("attachedTo", attachedTo.toString());
    }

    public static class CommentCreator
    extends DefaultCreator<Comment> {
        protected final Key<? extends ContentItem<?, ?>> attachedTo;
        protected final String description;

        public CommentCreator(NingConnection connection, NingClientConfig config, String endpoint, Comment comment) {
            super(connection, config, endpoint);
            this.attachedTo = comment.getAttachedTo();
            this.description = comment.getDescription();
        }

        @Override
        protected NingHttpPost addCreateParameters(NingHttpPost create) {
            if (this.attachedTo != null) {
                create = (NingHttpPost)create.addFormParameter("attachedTo", this.attachedTo.toString());
            }
            if (this.description != null) {
                create = (NingHttpPost)create.addFormParameter("description", this.description);
            }
            return create;
        }
    }

    public static class Lister
    extends DefaultLister<Comment, CommentField> {
        protected final Key<?> attachedTo;

        protected Lister(NingConnection connection, NingClientConfig config, String endpoint, Fields<CommentField> fields, Boolean isApproved, Key<?> attachedTo) {
            super(connection, config, endpoint, fields, null, null, isApproved);
            this.attachedTo = attachedTo;
        }

        public Lister approved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, Boolean.TRUE, this.attachedTo);
        }

        public Lister unapproved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, Boolean.FALSE, this.attachedTo);
        }

        @Override
        public PagedList<Comment> list() {
            return new PagedListImpl(this.connection, this.config, this.endpoint, Comment.class, this.fields, null, null, this.isApproved, Comments.attachedToParam(this.attachedTo));
        }
    }
}

