/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.auth;

import com.ning.api.client.auth.ConsumerKey;
import com.ning.api.client.auth.RequestToken;
import com.ning.api.client.auth.UTF8Codec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ThreadSafeHMAC {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final UTF8Codec utf8Codec = new UTF8Codec();
    private final Mac mac;

    public ThreadSafeHMAC(ConsumerKey consumerAuth, RequestToken userAuth) {
        byte[] keyBytes = utf8Codec.toUTF8(consumerAuth.getSecret() + "&" + userAuth.getSecret());
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        try {
            this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            this.mac.init(signingKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized byte[] digest(byte[] message) {
        this.mac.reset();
        return this.mac.doFinal(message);
    }
}

