/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http.async;

import com.ning.api.client.exception.NingTransferException;
import com.ning.api.client.exception.NingTransformException;
import com.ning.api.client.http.NingHttpResponse;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class AsyncResponseImpl
extends NingHttpResponse {
    private final Response rawResponse;
    private String responseBody;

    public AsyncResponseImpl(ObjectMapper objectMapper, Response rawResponse) {
        super(objectMapper);
        this.rawResponse = rawResponse;
    }

    @Override
    public int getStatusCode() {
        return this.rawResponse.getStatusCode();
    }

    @Override
    public String getResponseBody() throws NingTransferException {
        if (this.responseBody == null) {
            try {
                this.responseBody = this.rawResponse.getResponseBody();
            }
            catch (IOException ioe) {
                throw new NingTransferException(ioe);
            }
        }
        return this.responseBody;
    }

    @Override
    protected <T> T readAndBind(JavaType valueType) {
        this.verifyResponse();
        try {
            InputStream in = this.rawResponse.getResponseBodyAsStream();
            Object ob = this.objectMapper.readValue(in, valueType);
            return (T)ob;
        }
        catch (JsonProcessingException e) {
            throw new NingTransformException("Failed to bind JSON into type " + valueType + ": " + e.getMessage(), (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new NingTransferException("Failed to read data (of assumed type " + valueType + "): " + e.getMessage(), e);
        }
    }
}

