/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http.jdk;

import com.ning.api.client.auth.OAuthSignatureCalculator;
import com.ning.api.client.http.NingHttpResponse;
import com.ning.api.client.http.NingRequestBuilder;
import com.ning.api.client.http.jdk.JdkResponseImpl;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.jackson.map.ObjectMapper;

public class JdkRequestBuilderImpl
extends NingRequestBuilder<JdkRequestBuilderImpl> {
    protected final String baseURL;
    protected final String httpMethod;
    protected final OAuthSignatureCalculator signatureCalculator;
    protected ArrayList<String> headers;
    protected FluentStringsMap queryParameters;
    protected FluentStringsMap formParameters;
    protected String body;

    public JdkRequestBuilderImpl(String baseURL, OAuthSignatureCalculator sig, String httpMethod) {
        this.baseURL = baseURL;
        this.httpMethod = httpMethod;
        this.signatureCalculator = sig;
    }

    @Override
    public JdkRequestBuilderImpl addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        this.headers.add(name);
        this.headers.add(value);
        return this;
    }

    @Override
    public JdkRequestBuilderImpl addQueryParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new FluentStringsMap();
        }
        this.queryParameters.add(name, new String[]{value});
        return this;
    }

    @Override
    public JdkRequestBuilderImpl addFormParameter(String name, String value) {
        if (this.formParameters == null) {
            this.formParameters = new FluentStringsMap();
        }
        this.formParameters.add(name, new String[]{value});
        return this;
    }

    @Override
    public JdkRequestBuilderImpl setBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    public Future<NingHttpResponse> sendRequest(ObjectMapper objectMapper) throws IOException {
        String bodyToUse;
        URL url = this.buildURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setAllowUserInteraction(false);
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        conn.setDoOutput(this.body != null || this.formParameters != null);
        conn.setDoInput(true);
        conn.setRequestMethod(this.httpMethod);
        if (this.signatureCalculator != null) {
            String auth = this.signatureCalculator.calculateAuthorizationHeader(this.httpMethod, this.baseURL, this.formParameters, this.queryParameters);
            this.addHeader("Authorization", auth);
        }
        if ((bodyToUse = this.body) == null && this.formParameters != null) {
            StringBuilder sb = new StringBuilder(100);
            for (Map.Entry entry : this.formParameters) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb = UTF8UrlEncoder.appendEncoded((StringBuilder)sb, (String)key);
                    sb.append('=');
                    sb = UTF8UrlEncoder.appendEncoded((StringBuilder)sb, (String)value);
                }
            }
            bodyToUse = sb.toString();
        }
        return new RequestFuture(objectMapper, conn, this.headers, bodyToUse);
    }

    public URL buildURL() throws IOException {
        String url = this.baseURL;
        if (this.queryParameters != null) {
            StringBuilder sb = new StringBuilder(80);
            sb.append(url);
            int count = 0;
            for (Map.Entry entry : this.queryParameters) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    if (++count > 1) {
                        sb.append('&');
                    } else {
                        sb.append('?');
                    }
                    sb = UTF8UrlEncoder.appendEncoded((StringBuilder)sb, (String)key);
                    sb.append('=');
                    sb = UTF8UrlEncoder.appendEncoded((StringBuilder)sb, (String)value);
                }
            }
            url = sb.toString();
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IOException("Failed to construct URL from '" + url + "': " + e.getMessage(), e);
        }
    }

    protected static class RequestFuture
    implements Future<NingHttpResponse> {
        protected final ObjectMapper objectMapper;
        protected final HttpURLConnection connection;
        protected ArrayList<String> headers;
        protected final String body;

        public RequestFuture(ObjectMapper objectMapper, HttpURLConnection connection, ArrayList<String> headers, String body) {
            this.objectMapper = objectMapper;
            this.connection = connection;
            this.headers = headers;
            this.body = body;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public NingHttpResponse get() throws InterruptedException, ExecutionException {
            try {
                return this.completeRequest();
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public NingHttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (unit != TimeUnit.MILLISECONDS) {
                timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
            }
            this.connection.setConnectTimeout((int)timeout);
            this.connection.setReadTimeout((int)timeout);
            try {
                return this.completeRequest();
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }

        protected JdkResponseImpl completeRequest() throws IOException {
            if (this.headers != null) {
                int len = this.headers.size();
                for (int i = 0; i < len; i += 2) {
                    String name = this.headers.get(i);
                    String value = this.headers.get(i + 1);
                    this.connection.addRequestProperty(name, value);
                }
            }
            if (this.body != null) {
                OutputStream out = this.connection.getOutputStream();
                OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
                w.write(this.body);
                ((Writer)w).close();
            }
            return new JdkResponseImpl(this.objectMapper, this.connection);
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }
}

