/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.item;

import java.util.Collection;
import java.util.EnumSet;

public final class Fields<F extends Enum<F>> {
    protected final Class<F> enumClass;
    protected final EnumSet<F> included;

    public Fields(Class<F> enumClass) {
        this(enumClass, EnumSet.noneOf(enumClass));
    }

    public Fields(Class<F> enumClass, F first, F ... rest) {
        this(enumClass, EnumSet.of(first, rest));
    }

    public Fields(Class<F> enumClass, Collection<F> fields) {
        this(enumClass);
        this.included.addAll(fields);
    }

    private Fields(Class<F> enumClass, EnumSet<F> fields) {
        this.enumClass = enumClass;
        this.included = fields;
    }

    public Fields<F> add(F field) {
        this.included.add(field);
        return this;
    }

    public Fields<F> remove(F field) {
        this.included.remove(field);
        return this;
    }

    public boolean contains(F field) {
        return this.included.contains(field);
    }

    public boolean isEmpty() {
        return this.included.isEmpty();
    }

    public int size() {
        return this.included.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Fields other = (Fields)o;
        return other.enumClass == this.enumClass && this.included.equals(other.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        for (Enum entry : this.included) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(entry.toString());
        }
        return sb.toString();
    }
}

