/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.json;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.CustomDeserializerFactory;
import org.codehaus.jackson.map.deser.StdDeserializerProvider;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class ExtendedObjectMapper
extends ObjectMapper {
    public ExtendedObjectMapper() {
        this.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CustomDeserializerFactory f = new CustomDeserializerFactory();
        f.addSpecificMapping(ReadableDateTime.class, (JsonDeserializer)new ReadableDateTimeDeserializer());
        this.setDeserializerProvider((DeserializerProvider)new StdDeserializerProvider((DeserializerFactory)f));
    }

    private static class ReadableDateTimeDeserializer
    extends JsonDeserializer<ReadableDateTime> {
        private ReadableDateTimeDeserializer() {
        }

        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return new DateTime(jp.getLongValue(), DateTimeZone.UTC);
            }
            if (t == JsonToken.VALUE_STRING) {
                return new DateTime((Object)jp.getText().trim(), DateTimeZone.UTC);
            }
            throw new IOException("Can not deserialize ReadableDateTime out of " + t);
        }
    }
}

