/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client;

public class NingClientConfig {
    protected static final int DEFAULT_READ_TIMEOUT_MSECS = 8000;
    protected static final int DEFAULT_WRITE_TIMEOUT_MSECS = 5000;
    private static final NingClientConfig DEFAULT_SETTINGS = new NingClientConfig(8000, 5000);
    protected Integer readTimeoutMsecs;
    protected Integer writeTimeoutMsecs;

    public NingClientConfig() {
        this(8000, 5000);
    }

    public NingClientConfig(Integer readTimeoutMsecs, Integer writeTimeoutMsecs) {
        this.readTimeoutMsecs = readTimeoutMsecs;
        this.writeTimeoutMsecs = writeTimeoutMsecs;
    }

    public NingClientConfig withReadTimeoutMsecs(Integer value) {
        return new NingClientConfig(value, this.writeTimeoutMsecs);
    }

    public NingClientConfig withWriteTimeoutMsecs(Integer value) {
        return new NingClientConfig(this.readTimeoutMsecs, value);
    }

    public NingClientConfig overrideWith(NingClientConfig overrides) {
        if (overrides == null) {
            return this;
        }
        Integer readTimeout = this.choose(this.getReadTimeoutMsecs(), overrides.getReadTimeoutMsecs());
        Integer writeTimeout = this.choose(this.getWriteTimeoutMsecs(), overrides.getWriteTimeoutMsecs());
        return new NingClientConfig(readTimeout, writeTimeout);
    }

    public static NingClientConfig defaults() {
        return DEFAULT_SETTINGS;
    }

    public int getReadTimeoutMsecs() {
        return this.readTimeoutMsecs;
    }

    public int getWriteTimeoutMsecs() {
        return this.writeTimeoutMsecs;
    }

    protected <T> T choose(T baseline, T override) {
        if (override != null) {
            return override;
        }
        return baseline;
    }
}

