/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Items;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.DefaultCounter;
import com.ning.api.client.access.impl.DefaultCreator;
import com.ning.api.client.access.impl.DefaultDeleter;
import com.ning.api.client.access.impl.DefaultLister;
import com.ning.api.client.access.impl.DefaultUpdater;
import com.ning.api.client.access.impl.PagedListImpl;
import com.ning.api.client.action.Creator;
import com.ning.api.client.action.Deleter;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.action.Updater;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpPut;
import com.ning.api.client.http.NingHttpRequest;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.Key;
import com.ning.api.client.item.Photo;
import com.ning.api.client.item.PhotoField;
import com.ning.api.client.item.Visibility;
import org.joda.time.ReadableDateTime;

public class Photos
extends Items<Photo, PhotoField> {
    public Photos(NingConnection connection, NingClientConfig config) {
        super(connection, config, "Photo", Photo.class, PhotoField.class);
    }

    public Counter counter(ReadableDateTime createdAfter) {
        return new Counter(this.connection, this.config, this.endpointForCount(), createdAfter, null, null, null);
    }

    public Creator<Photo> creator(Photo photo) {
        return new PhotoCreator(this.connection, this.config, this.endpointForPOST(), photo);
    }

    public final Deleter<Photo> deleter(Key<Photo> id) {
        return new DefaultDeleter<Photo>(this.connection, this.config, this.endpointForDELETE(), id);
    }

    public Lister listerForRecent(PhotoField firstField, PhotoField ... otherFields) {
        return this.listerForRecent(new Fields(PhotoField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public Lister listerForRecent(Fields<PhotoField> fields) {
        return new Lister(this.connection, this.config, this.endpointForRecent(), fields, null, null, null);
    }

    public Updater<Photo> updater(Photo photo) {
        return new PhotoUpdater(this.connection, this.config, this.endpointForPUT(), photo);
    }

    public static class PhotoUpdater
    extends DefaultUpdater<Photo> {
        protected Photo photo;

        protected PhotoUpdater(NingConnection connection, NingClientConfig config, String endpoint, Photo photo) {
            super(connection, config, endpoint);
            this.photo = photo.clone();
        }

        public PhotoUpdater visibility(Visibility v) {
            this.photo = this.photo.clone();
            this.photo.setVisibility(v);
            return this;
        }

        public PhotoUpdater approved(Boolean approvedOrNot) {
            this.photo = this.photo.clone();
            this.photo.setApproved(approvedOrNot);
            return this;
        }

        @Override
        protected NingHttpPut addUpdateParameters(NingHttpPut put) {
            Key id = this.photo.id();
            if (id == null) {
                throw new IllegalArgumentException("Missing mandatory field 'id'");
            }
            put = (NingHttpPut)put.addFormParameter("id", id.toString());
            if (this.photo.getDescription() != null) {
                put = (NingHttpPut)put.addFormParameter("description", this.photo.getDescription());
            }
            if (this.photo.getTitle() != null) {
                put = (NingHttpPut)put.addFormParameter("title", this.photo.getTitle());
            }
            if (this.photo.getVisibility() != null) {
                put = (NingHttpPut)put.addFormParameter("visibility", this.photo.getVisibility().toString());
            }
            if (this.photo.isApproved() != null) {
                put = (NingHttpPut)put.addFormParameter("approved", this.photo.isApproved().toString());
            }
            return put;
        }
    }

    public static class Lister
    extends DefaultLister<Photo, PhotoField> {
        protected Lister(NingConnection connection, NingClientConfig config, String endpoint, Fields<PhotoField> fields, String author, Boolean isPrivate, Boolean isApproved) {
            super(connection, config, endpoint, fields, author, isPrivate, isApproved);
        }

        public Lister author(String author) {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, author, this.isPrivate, this.isApproved);
        }

        public Lister approved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, this.isPrivate, Boolean.TRUE);
        }

        public Lister unapproved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, this.isPrivate, Boolean.FALSE);
        }

        public Lister onlyPrivate() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, Boolean.TRUE, this.isApproved);
        }

        public Lister onlyPublic() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, Boolean.FALSE, this.isApproved);
        }

        @Override
        public PagedList<Photo> list() {
            return new PagedListImpl(this.connection, this.config, this.endpoint, Photo.class, this.fields, this.author, this.isPrivate, this.isApproved, new NingHttpRequest.Param[0]);
        }
    }

    public static class PhotoCreator
    extends DefaultCreator<Photo> {
        protected Photo photo;

        public PhotoCreator(NingConnection connection, NingClientConfig config, String endpoint, Photo Photo2) {
            super(connection, config, endpoint);
            this.photo = this.photo.clone();
        }

        public PhotoCreator visibility(Visibility v) {
            this.photo = this.photo.clone();
            this.photo.setVisibility(v);
            return this;
        }

        @Override
        protected NingHttpPost addCreateParameters(NingHttpPost create) {
            if (this.photo.getDescription() != null) {
                create = (NingHttpPost)create.addFormParameter("description", this.photo.getDescription());
            }
            if (this.photo.getTitle() != null) {
                create = (NingHttpPost)create.addFormParameter("title", this.photo.getTitle());
            }
            if (this.photo.getVisibility() != null) {
                create = (NingHttpPost)create.addFormParameter("visibility", this.photo.getVisibility().toString());
            }
            return create;
        }
    }

    public class Counter
    extends DefaultCounter {
        protected Counter(NingConnection connection, NingClientConfig config, String endpoint, ReadableDateTime createdAfter, String author, Boolean isPrivate, Boolean isApproved) {
            super(connection, config, endpoint, createdAfter, author, isPrivate, isApproved);
        }

        protected Counter(Counter base, String author, Boolean isPrivate, Boolean isApproved) {
            this(base.connection, base.config, base.endpoint, base.createdAfter, author, isPrivate, isApproved);
        }

        public Counter author(String author) {
            return new Counter(this, author, this.isPrivate, this.isApproved);
        }

        public Counter approved() {
            return new Counter(this, this.author, this.isPrivate, Boolean.TRUE);
        }

        public Counter unapproved() {
            return new Counter(this, this.author, this.isPrivate, Boolean.FALSE);
        }

        public Counter onlyPrivate() {
            return new Counter(this, this.author, Boolean.TRUE, this.isApproved);
        }

        public Counter onlyPublic() {
            return new Counter(this, this.author, Boolean.FALSE, this.isApproved);
        }
    }
}

