/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.sample;

import com.ning.api.client.access.Comments;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.item.Comment;
import com.ning.api.client.item.CommentField;
import com.ning.api.client.item.Key;
import com.ning.api.client.sample.SampleIntermediate;
import java.util.ArrayList;
import java.util.List;

public class ManualAddComment
extends SampleIntermediate {
    @Override
    public void doAction(NingConnection conn) throws Exception {
        Comments comments = conn.comments();
        String blogId = "688702:BlogPost:41";
        List<Comment> old = ManualAddComment.listComments(comments, blogId);
        System.out.println("Add new comment:");
        String desc = "Comment #" + (old.size() + 1) + " double+good, 100%";
        Comment newComment = new Comment(new Key(blogId), desc);
        comments.creator(newComment).create();
        System.out.println("Done!");
    }

    private static List<Comment> listComments(Comments comments, String blogId) throws Exception {
        System.out.println("Listing comments for '" + blogId + "':");
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (Comment comment : comments.listerForRecent(new Key(blogId), CommentField.id, CommentField.description, CommentField.author, CommentField.attachedToAuthor)) {
            result.add(comment);
            System.out.println(" #" + result.size() + ": " + comment.id() + ", desc=" + comment.getDescription() + ", author=" + comment.getAuthor() + ", attToAuthor=" + comment.getAttachedToAuthor());
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        new ManualAddComment().action();
    }
}

