/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http;

import com.ning.api.client.NingClientException;
import com.ning.api.client.auth.UTF8Codec;
import com.ning.api.client.exception.NingInterruptionException;
import com.ning.api.client.exception.NingProcessingException;
import com.ning.api.client.exception.NingTimeoutException;
import com.ning.api.client.exception.NingTransferException;
import com.ning.api.client.http.NingHttpResponse;
import com.ning.api.client.http.NingRequestBuilder;
import com.ning.api.client.json.ExtendedObjectMapper;
import com.ning.http.util.Base64;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.jackson.map.ObjectMapper;

public class NingHttpRequest<T extends NingHttpRequest<T>> {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    protected NingRequestBuilder<?> requestBuilder;
    protected static final ObjectMapper objectMapper = new ExtendedObjectMapper();
    private static final UTF8Codec utf8Codec = new UTF8Codec();
    protected String contentType;
    protected String contentEncoding;

    protected NingHttpRequest(NingRequestBuilder<?> requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    public NingHttpResponse execute(long timeoutMsecs) throws NingClientException {
        Future<NingHttpResponse> future;
        this.completeRequestBeforeExecute();
        try {
            future = this.requestBuilder.sendRequest(objectMapper);
        }
        catch (IOException e) {
            return (NingHttpResponse)this.handleAsNingException(e);
        }
        try {
            return future.get(timeoutMsecs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new NingInterruptionException(e);
        }
        catch (ExecutionException e) {
            return (NingHttpResponse)this.handleAsNingException(e);
        }
        catch (TimeoutException e) {
            throw new NingTimeoutException(e, timeoutMsecs);
        }
    }

    protected void completeRequestBeforeExecute() {
        NingRequestBuilder<?> rb = this.requestBuilder;
        if (this.contentType != null) {
            rb = rb.addHeader(HEADER_CONTENT_TYPE, this.contentType);
        }
        if (this.contentEncoding != null) {
            rb = rb.addHeader(HEADER_CONTENT_ENCODING, this.contentEncoding);
        }
        this.requestBuilder = rb;
    }

    public T addHeader(String name, String value) {
        this.requestBuilder = this.requestBuilder.addHeader(name, value);
        return this._this();
    }

    public T addQueryParameter(String name, String value) {
        this.requestBuilder = this.requestBuilder.addQueryParameter(name, value);
        return this._this();
    }

    public T addQueryParameter(Param p) {
        if (p != null) {
            this.addQueryParameter(p.name, p.value);
        }
        return this._this();
    }

    public T addQueryParameters(Param ... params) {
        if (params != null) {
            for (Param p : params) {
                this.addQueryParameter(p);
            }
        }
        return this._this();
    }

    public T setContentType(String type) {
        this.contentType = type;
        return this._this();
    }

    public T setContentEncoding(String enc) {
        this.contentEncoding = enc;
        return this._this();
    }

    public T addBasicAuth(String userName, String password) {
        String key = userName + ":" + password;
        String authAsBase64 = "Basic " + Base64.encode((byte[])utf8Codec.toUTF8(key));
        return this.addHeader(HEADER_AUTHORIZATION, authAsBase64);
    }

    public T addAccept(String acceptedTypes) {
        return this.addHeader(HEADER_ACCEPT, acceptedTypes);
    }

    protected T _this() {
        return (T)this;
    }

    protected StringBuilder appendUrlEncoded(StringBuilder result, String key, String value) {
        if (result == null) {
            result = new StringBuilder(100);
        } else {
            result.append('&');
        }
        UTF8UrlEncoder.appendEncoded((StringBuilder)result, (String)key);
        result.append('=');
        UTF8UrlEncoder.appendEncoded((StringBuilder)result, (String)value);
        return result;
    }

    protected Throwable peelExceptions(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    protected void throwIfUnchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    protected <R> R handleAsNingException(Throwable t) {
        t = this.peelExceptions(t);
        this.throwIfUnchecked(t);
        if (t instanceof IOException) {
            throw new NingTransferException((IOException)t);
        }
        throw new NingProcessingException(t);
    }

    public static class Param {
        protected final String name;
        protected final String value;

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

