/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http.async;

import com.ning.api.client.http.NingHttpResponse;
import com.ning.api.client.http.NingRequestBuilder;
import com.ning.api.client.http.async.AsyncResponseImpl;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.jackson.map.ObjectMapper;

public class AsyncRequestBuilderImpl
extends NingRequestBuilder<AsyncRequestBuilderImpl> {
    protected AsyncHttpClient.BoundRequestBuilder requestBuilder;

    public AsyncRequestBuilderImpl(AsyncHttpClient.BoundRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    public AsyncRequestBuilderImpl addHeader(String header, String value) {
        this.requestBuilder = this.requestBuilder.addHeader(header, value);
        return this;
    }

    @Override
    public AsyncRequestBuilderImpl addQueryParameter(String name, String value) {
        this.requestBuilder = this.requestBuilder.addQueryParameter(name, value);
        return this;
    }

    @Override
    public Future<NingHttpResponse> sendRequest(ObjectMapper objectMapper) throws IOException {
        return new ResponseFuture(objectMapper, this.requestBuilder.execute());
    }

    @Override
    public AsyncRequestBuilderImpl addFormParameter(String name, String value) {
        this.requestBuilder = this.requestBuilder.addParameter(name, value);
        return this;
    }

    @Override
    public AsyncRequestBuilderImpl setBody(String body) {
        this.requestBuilder = this.requestBuilder.setBody(body);
        return null;
    }

    protected static final class ResponseFuture
    implements Future<NingHttpResponse> {
        protected final ObjectMapper objectMapper;
        protected final Future<Response> futureImpl;

        public ResponseFuture(ObjectMapper objectMapper, Future<Response> futureImpl) {
            this.objectMapper = objectMapper;
            this.futureImpl = futureImpl;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureImpl.cancel(mayInterruptIfRunning);
        }

        @Override
        public NingHttpResponse get() throws InterruptedException, ExecutionException {
            return new AsyncResponseImpl(this.objectMapper, this.futureImpl.get());
        }

        @Override
        public NingHttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return new AsyncResponseImpl(this.objectMapper, this.futureImpl.get(timeout, unit));
        }

        @Override
        public boolean isCancelled() {
            return this.futureImpl.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureImpl.isDone();
        }
    }
}

