/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http.jdk;

import com.ning.api.client.exception.NingTransferException;
import com.ning.api.client.exception.NingTransformException;
import com.ning.api.client.http.NingHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class JdkResponseImpl
extends NingHttpResponse {
    protected final HttpURLConnection connection;
    protected final int responseCode;
    private String responseBody;

    public JdkResponseImpl(ObjectMapper objectMapper, HttpURLConnection connection) throws IOException {
        super(objectMapper);
        this.connection = connection;
        this.responseCode = connection.getResponseCode();
    }

    @Override
    public String getResponseBody() throws NingTransferException {
        if (this.responseBody == null) {
            InputStream in = null;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1000];
            try {
                int count;
                in = this.isError() ? this.connection.getErrorStream() : this.connection.getInputStream();
                InputStreamReader r = new InputStreamReader(in, "UTF-8");
                while ((count = r.read(buffer)) > 0) {
                    sb.append(buffer, 0, count);
                }
                r.close();
            }
            catch (IOException ioe) {
                throw new NingTransferException(ioe);
            }
            this.responseBody = sb.toString();
        }
        return this.responseBody;
    }

    @Override
    public int getStatusCode() {
        return this.responseCode;
    }

    protected boolean isError() {
        int code = this.getStatusCode();
        return code < 200 || code >= 300;
    }

    @Override
    protected <T> T readAndBind(JavaType valueType) {
        this.verifyResponse();
        try {
            InputStream in = this.connection.getInputStream();
            Object ob = this.objectMapper.readValue(in, valueType);
            return (T)ob;
        }
        catch (JsonProcessingException e) {
            throw new NingTransformException("Failed to bind JSON into type " + valueType + ": " + e.getMessage(), (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new NingTransferException("Failed to read data (of assumed type " + valueType + "): " + e.getMessage(), e);
        }
    }
}

