/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.auth.ConsumerKey;
import com.ning.api.client.auth.RequestToken;
import com.ning.api.client.http.NingHttpClient;
import com.ning.api.client.http.NingHttpException;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpResponse;
import com.ning.api.client.http.async.AsyncClientImpl;
import com.ning.api.client.item.Token;
import java.io.IOException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class NingClient {
    public static final int XAPI_REGULAR_PORT = 80;
    public static final int XAPI_SECURE_PORT = 443;
    public static final String DEFAULT_HOST = "external.ningapis.com";
    public final String API_PATH_PREFIX = "/xn/rest/";
    public final String API_VERSION = "/1.0/";
    protected NingClientConfig config = NingClientConfig.defaults();
    protected final String networkId;
    protected final ConsumerKey consumerAuth;
    protected final String xapiPrefixRegular;
    protected final String xapiPrefixSecure;
    private final ObjectMapper objectMapper;
    private final NingHttpClient httpClient;

    public NingClient(String networkId, ConsumerKey consumerAuth) {
        this(null, networkId, consumerAuth, null);
    }

    public NingClient(NingHttpClient httpClient, String networkId, ConsumerKey consumerAuth) {
        this(httpClient, networkId, consumerAuth, null);
    }

    public NingClient(String networkId, ConsumerKey consumerAuth, String host) {
        this(null, networkId, consumerAuth, host, -1, -1);
    }

    public NingClient(NingHttpClient httpClient, String networkId, ConsumerKey consumerAuth, String host) {
        this(httpClient, networkId, consumerAuth, host, -1, -1);
    }

    public NingClient(String networkId, ConsumerKey consumerAuth, String host, int port, int securePort) {
        this(null, networkId, consumerAuth, host, port, securePort);
    }

    public NingClient(NingHttpClient httpClient, String networkId, ConsumerKey consumerAuth, String host, int port, int securePort) {
        if (httpClient == null) {
            httpClient = NingClient.constructDefaultHttpClient();
        }
        this.httpClient = httpClient;
        this.networkId = networkId;
        this.consumerAuth = consumerAuth;
        if (host == null) {
            host = DEFAULT_HOST;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(host).append(":");
        sb.append(port > 0 ? port : 80);
        sb.append("/xn/rest/").append(networkId).append("/1.0/");
        this.xapiPrefixRegular = sb.toString();
        sb = new StringBuilder();
        sb.append("https://").append(host).append(":");
        sb.append(securePort > 0 ? securePort : 443);
        sb.append("/xn/rest/").append(networkId).append("/1.0/");
        this.xapiPrefixSecure = sb.toString();
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static NingHttpClient constructDefaultHttpClient() {
        return new AsyncClientImpl();
    }

    public NingClientConfig getConfig() {
        return this.config;
    }

    public void overrideConfig(NingClientConfig configOverrides) {
        this.config = this.config.overrideWith(configOverrides);
    }

    public Token createToken(String user, String userPassword) throws IOException {
        String url = this.xapiPrefixSecure + "Token";
        NingHttpPost post = this.httpClient.preparePost(url, null);
        post = (NingHttpPost)post.addBasicAuth(user, userPassword);
        post = (NingHttpPost)post.addAccept("*/*");
        NingHttpResponse resp = (post = (NingHttpPost)((NingHttpPost)((NingHttpPost)post.addFormParameter("oauth_signature_method", "PLAINTEXT")).addFormParameter("oauth_consumer_key", this.consumerAuth.getKey())).addFormParameter("oauth_signature", this.consumerAuth.getSecret() + "&")).execute(this.config.getReadTimeoutMsecs());
        int code = resp.getStatusCode();
        if (code != 200) {
            String msg = resp.safeGetResponseBody();
            switch (code) {
                case 401: {
                    throw new NingHttpException(code, msg, "Invalid credentials (network '" + this.networkId + "'); not authorized to create a Token");
                }
                case 500: 
                case 503: 
                case 504: {
                    throw new IllegalStateException("Server-side problem (code " + code + "), error message: " + resp.safeGetResponseBody());
                }
            }
            throw new IllegalStateException("Unrecognized problem (code " + code + "), error message: " + resp.safeGetResponseBody());
        }
        Token tokenResp = resp.asSingleItem(Token.class);
        return tokenResp;
    }

    public NingConnection connect(Token token) {
        return this.connect(token, null);
    }

    public NingConnection connect(Token token, NingClientConfig override) {
        return this.connect(new RequestToken(token.getOauthToken(), token.getOauthTokenSecret()), override);
    }

    public NingConnection connect(RequestToken userAuth) {
        return this.connect(userAuth, null);
    }

    public NingConnection connect(RequestToken userAuth, NingClientConfig override) {
        NingClientConfig connectionConfig = this.config.overrideWith(override);
        return new NingConnection(connectionConfig, this.objectMapper, this.consumerAuth, userAuth, this.httpClient, this.xapiPrefixRegular, this.xapiPrefixSecure);
    }
}

