/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.model.basic.datamodel;

import com.nosolojava.fsm.impl.model.basic.datamodel.BasicParam;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.datamodel.Body;
import com.nosolojava.fsm.model.datamodel.Content;
import com.nosolojava.fsm.model.datamodel.Param;
import com.nosolojava.fsm.runtime.Context;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasicBody
implements Body {
    private final Content content;
    private final boolean isParamsBody;
    private final Map<String, Param> params;

    private BasicBody(Content content, Map<String, Param> params, boolean isParamsBody) {
        this.content = content;
        this.params = params;
        this.isParamsBody = isParamsBody;
    }

    public static BasicBody createContentBody(Content content) {
        BasicBody result = new BasicBody(content, null, false);
        return result;
    }

    public static BasicBody createParamsBody(Set<Param> params, String namelist) throws ConfigurationException {
        HashMap<String, Param> paramMap = new HashMap<String, Param>();
        for (Param param : params) {
            paramMap.put(param.getName(), param);
        }
        if (namelist != null && !"".equals(namelist.trim())) {
            String[] names;
            for (String name : names = namelist.split(" ")) {
                BasicParam aux = new BasicParam(name, null, name);
                paramMap.put(name, aux);
            }
        }
        BasicBody result = new BasicBody(null, paramMap, true);
        return result;
    }

    public <T> T evaluateBody(Context context) {
        HashMap<String, Object> result = null;
        if (this.content != null) {
            result = this.content.evaluateContent(context);
        } else if (this.params != null) {
            result = this.evaluateParams(context);
        }
        return (T)result;
    }

    private HashMap<String, Object> evaluateParams(Context context) {
        HashMap<String, Object> runtimeParams = new HashMap<String, Object>();
        if (!this.params.isEmpty()) {
            for (Map.Entry<String, Param> entry : this.params.entrySet()) {
                Object value = entry.getValue().evaluateParam(context);
                runtimeParams.put(entry.getKey(), value);
            }
        }
        return runtimeParams;
    }

    public Set<String> getLocations() {
        HashSet<String> result = new HashSet<String>();
        if (this.params != null && !this.params.isEmpty()) {
            for (Param param : this.params.values()) {
                if (param.getLocation() == null) continue;
                result.add(param.getLocation());
            }
        }
        return result;
    }

    public boolean isParamsBody() {
        return this.isParamsBody;
    }
}

