/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.basic;

import com.nosolojava.fsm.impl.model.basic.jexl.JexlFSMContext;
import com.nosolojava.fsm.impl.runtime.basic.BasicStateMachineFramework;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.AbstractBasicInvokeHandler;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.invokeHandler.ConsoleInvokeHandler;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.invokeHandler.ScxmlInvokeHandler;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.io.ConsoleIOProcessor;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.io.ScxmlIOProcessor;
import com.nosolojava.fsm.model.StateMachineModel;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.parser.StateMachineParser;
import com.nosolojava.fsm.parser.XppActionParser;
import com.nosolojava.fsm.parser.XppStateMachineParser;
import com.nosolojava.fsm.parser.exception.SCXMLParserException;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.ContextFactory;
import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.FSMLogCallback;
import com.nosolojava.fsm.runtime.StateMachineEngine;
import com.nosolojava.fsm.runtime.StateMachineFramework;
import com.nosolojava.fsm.runtime.executable.externalcomm.IOProcessor;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicStateMachineEngine
implements StateMachineEngine {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static AtomicInteger CHECK_AVAILABLE_SESSIONS_PERIOD_IN_MILLIS = new AtomicInteger(5000);
    private final ConcurrentMap<String, IOProcessor> ioProcessorMap = new ConcurrentHashMap<String, IOProcessor>();
    private ConcurrentMap<String, Context> scxmlSessionMap = new ConcurrentHashMap<String, Context>();
    private ConcurrentMap<String, InvokeHandler> invokeHandlerMap = new ConcurrentHashMap<String, InvokeHandler>();
    private StateMachineParser parser;
    private StateMachineFramework framework;
    private FSMLogCallback logCallback;
    protected final ReentrantLock startStopLock = new ReentrantLock();
    protected volatile AtomicBoolean isActive = new AtomicBoolean(false);
    private ExecutorService dispatcherExecutor = null;
    private final BlockingQueue<Context> availableSessions = this.createBusyPriorityBlockingQueue();
    protected final ReentrantLock sessionLock = new ReentrantLock();
    private ConcurrentMap<String, Context> busySessionMap = new ConcurrentHashMap<String, Context>();
    private ConcurrentMap<String, Context> emptySessionMap = new ConcurrentHashMap<String, Context>();
    private ExecutorService contextEventsExecutor = Executors.newCachedThreadPool();
    ContextFactory contextFactory = new ContextFactory(){

        public Context createContext(String sessionId, String parentSessionId, StateMachineModel model, StateMachineEngine engine, Map<String, Serializable> initValues) throws ConfigurationException {
            return new JexlFSMContext(sessionId, parentSessionId, model, engine, initValues);
        }
    };

    public BasicStateMachineEngine() throws ConfigurationException {
        this(null);
    }

    public BasicStateMachineEngine(List<XppActionParser> customActionParsers) throws ConfigurationException {
        this(customActionParsers, null);
    }

    public BasicStateMachineEngine(List<XppActionParser> customActionParsers, FSMLogCallback logCallback) throws ConfigurationException {
        this.logCallback = logCallback;
        this.parser = customActionParsers != null ? new XppStateMachineParser(customActionParsers) : new XppStateMachineParser();
        this.initDefaultValues();
    }

    protected void initDefaultValues() {
        this.framework = new BasicStateMachineFramework(this.logCallback);
        this.framework.setEngine((StateMachineEngine)this);
        Object ioProcessor = new ScxmlIOProcessor(this);
        this.ioProcessorMap.put(ioProcessor.getName(), (IOProcessor)ioProcessor);
        ioProcessor = new ConsoleIOProcessor(this);
        this.ioProcessorMap.put(ioProcessor.getName(), (IOProcessor)ioProcessor);
        AbstractBasicInvokeHandler invokeHandler = new ScxmlInvokeHandler(this);
        this.invokeHandlerMap.put(invokeHandler.getType(), invokeHandler);
        invokeHandler = new ConsoleInvokeHandler();
        this.invokeHandlerMap.put(invokeHandler.getType(), invokeHandler);
    }

    public void start() {
        block5: {
            if (this.isActive.get()) {
                throw new RuntimeException("Engine can't be started twice, create a new instance");
            }
            try {
                this.startStopLock.lock();
                if (this.isActive.compareAndSet(false, true)) {
                    this.dispatcherExecutor = Executors.newSingleThreadExecutor();
                    this.dispatcherExecutor.execute(new DispatchEventsTask());
                    break block5;
                }
                throw new RuntimeException("Engine can't be started twice, create a new instance");
            }
            finally {
                this.startStopLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result;
        block5: {
            result = false;
            try {
                this.startStopLock.lock();
                if (this.isActive.compareAndSet(true, false)) {
                    this.dispatcherExecutor.shutdown();
                    break block5;
                }
                throw new RuntimeException("This engine has not been started or has been shutdown before, create a new instance.");
            }
            finally {
                this.startStopLock.unlock();
            }
        }
        if (timeout > -1L) {
            result = this.dispatcherExecutor.awaitTermination(timeout, unit);
        }
        this.contextEventsExecutor.shutdown();
        this.scxmlSessionMap.clear();
        return result;
    }

    public void forceShutdown() {
        try {
            this.shutdownAndWait(-1L, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Context startFSMSession(URI fsmModelUri) throws ConfigurationException, IOException, SCXMLParserException {
        return this.startFSMSession(null, null, fsmModelUri, null);
    }

    public Context startFSMSession(String parentSessionId, URI fsmModelUri) throws ConfigurationException, IOException, SCXMLParserException {
        return this.startFSMSession(null, parentSessionId, fsmModelUri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context startFSMSession(String sessionId, String parentSessionId, URI fsmModelUri, Map<String, Serializable> initValues) throws ConfigurationException, IOException, SCXMLParserException {
        Context context;
        block20: {
            block18: {
                try {
                    this.startStopLock.lock();
                    if (!this.isActive.get()) {
                        throw new RuntimeException("This engine has not been started or has been shutdown before, create a new instance.");
                    }
                }
                finally {
                    this.startStopLock.unlock();
                }
                StateMachineModel model = this.parser.parseScxml(fsmModelUri);
                context = this.contextFactory.createContext(sessionId, parentSessionId, model, (StateMachineEngine)this, initValues);
                try {
                    this.startStopLock.lock();
                    if (this.isActive.get()) {
                        this.scxmlSessionMap.put(context.getSessionId(), context);
                        break block18;
                    }
                    throw new RuntimeException("This engine has not been started or has been shutdown before, create a new instance.");
                }
                finally {
                    this.startStopLock.unlock();
                }
            }
            try {
                this.framework.initFSM(context);
            }
            catch (Exception e) {
                try {
                    this.startStopLock.lock();
                    this.scxmlSessionMap.remove(context.getSessionId());
                }
                finally {
                    this.startStopLock.unlock();
                }
                throw e;
            }
            try {
                this.startStopLock.lock();
                if (this.isActive.get()) {
                    this.availableSessions.offer(context);
                    break block20;
                }
                throw new RuntimeException("This engine has not been started or has been shutdown before, create a new instance.");
            }
            finally {
                this.startStopLock.unlock();
            }
        }
        return context;
    }

    public Context getSession(String sessionId) {
        return (Context)this.scxmlSessionMap.get(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(String sessionId, Event event) {
        if (this.scxmlSessionMap.containsKey(sessionId)) {
            try {
                this.sessionLock.lock();
                Context context = (Context)this.scxmlSessionMap.get(sessionId);
                if (this.emptySessionMap.containsKey(sessionId)) {
                    this.emptySessionMap.remove(sessionId);
                    this.availableSessions.offer(context);
                }
                context.offerExternalEvent(event);
            }
            finally {
                this.sessionLock.unlock();
            }
        }
    }

    public boolean isSessionActive(String sessionId) {
        return this.scxmlSessionMap.containsKey(sessionId);
    }

    public void endSession(String sessionId) {
        this.scxmlSessionMap.remove(sessionId);
    }

    public void registerIOProcessor(IOProcessor ioProcessor) {
        ioProcessor.setEngine((StateMachineEngine)this);
        this.ioProcessorMap.put(ioProcessor.getName(), ioProcessor);
    }

    public void unRegisterIOProcessor(String name) {
        if (this.ioProcessorMap.containsKey(name)) {
            ((IOProcessor)this.ioProcessorMap.get(name)).setEngine(null);
            this.ioProcessorMap.remove(name);
        }
    }

    public void registerInvokeHandler(InvokeHandler invokeHandler) {
        if (invokeHandler != null && invokeHandler.getType() != null) {
            this.invokeHandlerMap.put(invokeHandler.getType(), invokeHandler);
        }
    }

    public void unRegisterInvokeHandler(String type) {
        this.invokeHandlerMap.remove(type);
    }

    public StateMachineParser getParser() {
        return this.parser;
    }

    public void setParser(StateMachineParser parser) {
        this.parser = parser;
    }

    public void setStateMachineFramework(StateMachineFramework framework) {
        this.framework = framework;
    }

    public Set<IOProcessor> getIOProcessors() {
        return new HashSet<IOProcessor>(this.ioProcessorMap.values());
    }

    public IOProcessor getIOProcessor(String name) {
        return (IOProcessor)this.ioProcessorMap.get(name);
    }

    public Set<InvokeHandler> getInvokeHandlers() {
        return new HashSet<InvokeHandler>(this.invokeHandlerMap.values());
    }

    public InvokeHandler getInvokeHandler(String type) {
        return (InvokeHandler)this.invokeHandlerMap.get(type);
    }

    public StateMachineFramework getStateMachineFramework() {
        return this.framework;
    }

    protected PriorityBlockingQueue<Context> createBusyPriorityBlockingQueue() {
        return new PriorityBlockingQueue<Context>(11, new Comparator<Context>(){

            @Override
            public int compare(Context object1, Context object2) {
                if (object1 == object2) {
                    return 0;
                }
                if (object1 == null) {
                    return 1;
                }
                if (object2 == null) {
                    return -1;
                }
                if (object1.hasExternalEvents() && !object1.hasInternalEvents()) {
                    return -1;
                }
                if (object1.hasExternalEvents() && object1.hasInternalEvents()) {
                    if (object2.hasExternalEvents() && !object2.hasInternalEvents()) {
                        return 1;
                    }
                    return -1;
                }
                if (object2.hasExternalEvents()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public Collection<Context> getActiveSessions() {
        return this.scxmlSessionMap.values();
    }

    public void setContextFactory(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setLogCallback(FSMLogCallback logCallback) {
        this.logCallback = logCallback;
    }

    public FSMLogCallback getLogCallback() {
        return this.logCallback;
    }

    class PushEventTask
    implements Runnable {
        private final Context context;
        private final Event event;

        public PushEventTask(Event event, Context context) {
            this.event = event;
            this.context = context;
        }

        @Override
        public void run() {
            BasicStateMachineEngine.this.getStateMachineFramework().handleExternalEvent(this.event, this.context);
            try {
                BasicStateMachineEngine.this.sessionLock.lock();
                BasicStateMachineEngine.this.busySessionMap.remove(this.context.getSessionId());
                if (BasicStateMachineEngine.this.scxmlSessionMap.containsKey(this.context.getSessionId())) {
                    if (this.context.hasExternalEvents()) {
                        BasicStateMachineEngine.this.availableSessions.offer(this.context);
                    } else {
                        BasicStateMachineEngine.this.emptySessionMap.put(this.context.getSessionId(), this.context);
                    }
                }
            }
            finally {
                BasicStateMachineEngine.this.sessionLock.unlock();
            }
        }
    }

    class DispatchEventsTask
    implements Runnable {
        DispatchEventsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BasicStateMachineEngine engineInstance = BasicStateMachineEngine.this;
                while (engineInstance.isActive.get() || !engineInstance.scxmlSessionMap.isEmpty()) {
                    Context availableContext = (Context)engineInstance.availableSessions.poll(CHECK_AVAILABLE_SESSIONS_PERIOD_IN_MILLIS.get(), TimeUnit.MILLISECONDS);
                    if (availableContext == null) continue;
                    if (availableContext.hasExternalEvents()) {
                        Event event = availableContext.pollExternalEvent();
                        PushEventTask pushEventtask = new PushEventTask(event, availableContext);
                        try {
                            BasicStateMachineEngine.this.sessionLock.lock();
                            BasicStateMachineEngine.this.busySessionMap.put(availableContext.getSessionId(), availableContext);
                        }
                        finally {
                            BasicStateMachineEngine.this.sessionLock.unlock();
                        }
                        if (engineInstance.contextEventsExecutor.isShutdown()) continue;
                        engineInstance.contextEventsExecutor.execute(pushEventtask);
                        continue;
                    }
                    engineInstance.availableSessions.offer(availableContext);
                }
            }
            catch (InterruptedException e) {
                BasicStateMachineEngine.this.logger.log(Level.SEVERE, "Interrupted exception");
            }
        }
    }
}

