/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.basic;

import com.nosolojava.fsm.impl.runtime.basic.BasicEvent;
import com.nosolojava.fsm.impl.runtime.basic.PlatformEvents;
import com.nosolojava.fsm.impl.runtime.basic.StateMachineUtils;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicMessage;
import com.nosolojava.fsm.model.StateMachineModel;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.config.exception.ParallelSiblingTransactionException;
import com.nosolojava.fsm.model.datamodel.Data;
import com.nosolojava.fsm.model.externalcomm.Invoke;
import com.nosolojava.fsm.model.state.DoneData;
import com.nosolojava.fsm.model.state.HistoryTypes;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.model.transition.Transition;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.FSMLogCallback;
import com.nosolojava.fsm.runtime.StateMachineEngine;
import com.nosolojava.fsm.runtime.StateMachineFramework;
import com.nosolojava.fsm.runtime.executable.Executable;
import com.nosolojava.fsm.runtime.executable.externalcomm.IOProcessor;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import com.nosolojava.fsm.runtime.listener.FSMListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicStateMachineFramework
implements StateMachineFramework {
    private static final String HISTORY_STATES = "_historyStates";
    public static final AtomicBoolean DEBUG = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<FSMListener> listeners = new CopyOnWriteArrayList();
    private FSMLogCallback logCallback;
    private StateMachineEngine engine = null;

    public BasicStateMachineFramework() {
        this(null);
    }

    public BasicStateMachineFramework(FSMLogCallback logCallback) {
        this(logCallback, null);
    }

    public BasicStateMachineFramework(FSMLogCallback logCallback, List<FSMListener> listeners) {
        if (logCallback == null) {
            logCallback = this.createBasicLogCallback();
        }
        this.logCallback = logCallback;
        if (listeners != null && !listeners.isEmpty()) {
            this.listeners.addAll(listeners);
        }
    }

    public void initFSM(Context context) throws ConfigurationException {
        if (DEBUG.get()) {
            this.logFine("####################################################################################");
            this.logFine("init FSM sessionid {0}", new Object[]{context.getSessionId()});
        }
        context.createVarIfDontExist(HISTORY_STATES, new HashMap());
        StateMachineModel model = context.getModel();
        this.validateStates(context, model.getRootState());
        Transition initialTransition = model.getRootState().getInitialState().getInitialTransition();
        this.executeContent(context, initialTransition.getExecutables());
        this.enterState(context, initialTransition);
        this.macroStep(context);
        for (FSMListener listener : this.listeners) {
            listener.onSessionStarted(context.getLastStableConfiguration());
        }
    }

    protected FSMLogCallback createBasicLogCallback() {
        FSMLogCallback logCallback = new FSMLogCallback(){
            private Logger logger = Logger.getLogger("com.nosolojava.fsm.BasicStateMachine");

            public void logWarning(String text) {
                this.logger.log(Level.WARNING, text);
            }

            public void logInfo(String text) {
                this.logger.log(Level.INFO, text);
            }

            public void logError(String text) {
                this.logger.log(Level.SEVERE, text);
            }

            public void logDebug(String text) {
                this.logger.log(Level.FINE, text);
            }

            public void logDebug(String text, Object[] data) {
                this.logger.log(Level.FINE, text, data);
            }
        };
        return logCallback;
    }

    private void validateStates(Context context, State rootState) throws ConfigurationException {
        if (!rootState.isRootState()) {
            throw new ConfigurationException("First document states should be root state childrens.");
        }
        for (State state : rootState.getChildrens()) {
            this.validateStateRec(context, state);
        }
    }

    private void validateStateRec(Context context, State state) throws ConfigurationException {
        if (state.isRootState()) {
            throw new ConfigurationException("There can be only one root state");
        }
        if (state.hasChildrens()) {
            if (state.isParallel()) {
                this.validateNoTransitionBetweenParallelSiblings(context, state);
            }
            for (State children : state.getChildrens()) {
                this.validateStateRec(context, children);
            }
        }
    }

    private void validateNoTransitionBetweenParallelSiblings(Context context, State parallelState) throws ParallelSiblingTransactionException {
        List<State> stateList = StateMachineUtils.stateToList(parallelState);
        for (State state : stateList) {
            for (Transition transition : state.getTransitions()) {
                State lca;
                if (transition.getTargetState(context) == null || !(lca = this.calculateTransitionAncestor(context, transition)).equals(parallelState)) continue;
                throw new ParallelSiblingTransactionException(transition);
            }
        }
    }

    public void pushInternalEvent(Context context, Event event) {
        context.offerInternalEvent(event);
    }

    public void handleExternalEvent(Event externalEvent, Context context) {
        if (DEBUG.get()) {
            this.logFine("####################################################################################");
            this.logFine("@@@ event {0}, receiving session id: {1}", new Object[]{externalEvent, context.getSessionId()});
        }
        if (externalEvent != null) {
            context.setCurrentEvent(externalEvent);
            this.manageInvokes(context, externalEvent);
            List<Transition> enabledTransitions = this.selectNormalTransitions(context, externalEvent);
            if (!enabledTransitions.isEmpty()) {
                if (DEBUG.get()) {
                    this.logFine("--> transition/s FOUND " + enabledTransitions);
                }
                this.microstep(context, enabledTransitions);
                this.manageInternalEvents(context);
            }
        }
        this.macroStep(context);
    }

    protected void macroStep(Context context) {
        this.manageInternalEvents(context);
        this.callInvokes(context);
        this.manageInternalEvents(context);
        context.saveCurrentConfiguration();
        for (FSMListener listener : this.listeners) {
            listener.onNewState(context.getLastStableConfiguration());
        }
        boolean finalState = this.isFinalStateReached(context);
        if (finalState) {
            for (FSMListener listener : this.listeners) {
                listener.onSessionEnd(context.getLastStableConfiguration());
            }
            this.exitInterpreter(context);
        }
        if (DEBUG.get()) {
            this.logFine("End macrostep, session id {0}, current event: {1}", new Object[]{context.getSessionId(), context.getCurrentEvent()});
            this.logFine("Active states {0}", new Object[]{context.getActiveStates()});
            this.logFine("####################################################################################");
        }
    }

    private boolean isFinalStateReached(Context context) {
        boolean finalState = false;
        Iterator it = context.getActiveStates().iterator();
        while (!finalState && it.hasNext()) {
            State state = (State)it.next();
            if (!state.isFinal() || !state.getParent().isRootState()) continue;
            finalState = true;
        }
        return finalState;
    }

    private void manageInternalEvents(Context context) {
        boolean macroStepComplete = false;
        while (!macroStepComplete) {
            List<Transition> enabledTransitions = this.selectEventLessTransitions(context);
            if (enabledTransitions.isEmpty()) {
                if (!context.hasInternalEvents()) {
                    macroStepComplete = true;
                } else {
                    Event internalEvent = context.pollInternalEvent();
                    if (DEBUG.get()) {
                        this.logFine("@@@ internal event " + internalEvent);
                    }
                    context.setCurrentEvent(internalEvent);
                    enabledTransitions = this.selectNormalTransitions(context, internalEvent);
                }
            }
            if (enabledTransitions.isEmpty()) continue;
            if (DEBUG.get()) {
                this.logFine("<--> internal transitions found: {0} ", new Object[]{enabledTransitions});
            }
            this.microstep(context, enabledTransitions);
        }
    }

    private void callInvokes(Context context) {
        if (DEBUG.get()) {
            this.logFine("Check if there are invokes to call");
        }
        SortedSet statesToInvoke = context.getStatesToInvoke();
        for (State state : statesToInvoke) {
            this.invokeAll(context, state);
        }
        context.clearStatesToInvoke();
    }

    private void manageInvokes(Context context, Event externalEvent) {
        for (State state : context.getActiveStates()) {
            for (Invoke invoke : state.getInvokes()) {
                String invokeId = invoke.getId(context);
                if (invokeId.equals(externalEvent.getInvokeId())) {
                    this.applyInvokeFinalize(context, invoke, externalEvent);
                }
                if (!invoke.isAutoforward()) continue;
                if (DEBUG.get()) {
                    this.logFine("forward event {0} to invoke session {1}", new Object[]{externalEvent.getName(), invoke.getId(context)});
                }
                invoke.manageEvent(externalEvent, context);
            }
        }
    }

    private void exitInterpreter(Context context) {
        if (context.getParentSessionId() != null) {
            Message sessionDoneMessage = this.createDoneSessionMessage(context);
            for (IOProcessor ioProcessor : context.getIOProcessors()) {
                ioProcessor.sendMessageFromFSM(sessionDoneMessage);
            }
        }
        this.engine.endSession(context.getSessionId());
    }

    private Message createDoneSessionMessage(Context context) {
        String sessionDoneEventName = PlatformEvents.DONE_INVOKE_PREFIX.getEventName() + context.getSessionId();
        SortedSet finalStates = context.getActiveStates();
        State finalState = (State)finalStates.first();
        DoneData doneData = finalState.getDoneData();
        Serializable body = doneData != null ? doneData.evaluateDoneData(context) : null;
        Message message = BasicMessage.createSimpleSCXMLMessage(sessionDoneEventName, context.getParentSessionId(), body, context);
        return message;
    }

    private void microstep(Context context, List<Transition> enabledTransitions) {
        if (DEBUG.get()) {
            this.logFine("++++++++++++++++++++++++++++++++++++");
            this.logFine("Microstep, activeStates {0}", new Object[]{context.getActiveStates()});
            this.logFine("++++++++++++++++++++++++++++++++++++");
        }
        this.exitStates(context, enabledTransitions);
        this.executeTransitionContent(context, enabledTransitions);
        this.enterStates(context, enabledTransitions);
        if (DEBUG.get()) {
            this.logFine("END microstep, activeStates {0}", new Object[]{context.getActiveStates()});
            this.logFine("++++++++++++++++++++++++++++++++++++");
        }
    }

    private List<Transition> selectNormalTransitions(Context context, Event event) {
        return this.selectTransitions(context, event, false);
    }

    private List<Transition> selectEventLessTransitions(Context context) {
        return this.selectTransitions(context, null, true);
    }

    private List<Transition> selectTransitions(Context context, Event event, boolean eventless) {
        ArrayList<Transition> enabledTransitions = new ArrayList<Transition>();
        for (State atomicActiveState : context.getActiveStates()) {
            Transition enabledTransition;
            if (this.isPreempted(context, atomicActiveState, enabledTransitions) || (enabledTransition = !eventless ? this.searchNormalTransitionInAStateAndAncestors(context, atomicActiveState, event) : this.searchEventlessTransitionInAStateAndAncestors(context, atomicActiveState)) == null) continue;
            enabledTransitions.add(enabledTransition);
        }
        return enabledTransitions;
    }

    private boolean isPreempted(Context context, State atomicActiveState, ArrayList<Transition> enabledTransitions) {
        boolean result = false;
        Iterator<Transition> transitionIter = enabledTransitions.iterator();
        while (!result && transitionIter.hasNext()) {
            Transition transition = transitionIter.next();
            if (transition.getTargetState(context) != null) {
                State LCA = this.searchLCA(context, transition);
                if (LCA.isRootState()) {
                    result = true;
                    continue;
                }
                result = atomicActiveState.isDescendant(LCA);
                continue;
            }
            result = false;
        }
        return result;
    }

    protected State searchLCA(Context context, Transition transition) {
        State[] states = new State[]{transition.getSourceState(context), transition.getTargetState(context)};
        return this.searchLCA(context, states);
    }

    protected State searchLCA(Context context, State[] states) {
        State LCA = context.getModel().getRootState();
        Iterator[] breadcrumbs = new Iterator[states.length];
        boolean foundLCA = false;
        for (int i = 0; i < states.length && !foundLCA; ++i) {
            if (states[i].isRootState()) {
                foundLCA = true;
                continue;
            }
            List breadcrumb = states[i].getBreadCrumb();
            breadcrumbs[i] = breadcrumb.iterator();
        }
        while (!foundLCA) {
            State candidate;
            State state = candidate = breadcrumbs[0].hasNext() ? (State)breadcrumbs[0].next() : null;
            if (candidate != null) {
                for (int i = 1; i < states.length && !foundLCA; ++i) {
                    State other;
                    State state2 = other = breadcrumbs[i].hasNext() ? (State)breadcrumbs[i].next() : null;
                    if (other != null && other.equals(candidate)) continue;
                    foundLCA = true;
                }
                if (foundLCA) continue;
                LCA = candidate;
                continue;
            }
            foundLCA = true;
        }
        return LCA;
    }

    private Transition searchEventlessTransitionInAStateAndAncestors(Context context, State activeState) {
        return this.searchTransitionInAStateAndAncestors(context, activeState, null, true);
    }

    private Transition searchNormalTransitionInAStateAndAncestors(Context context, State activeState, Event event) {
        return this.searchTransitionInAStateAndAncestors(context, activeState, event, false);
    }

    private Transition searchTransitionInAStateAndAncestors(Context context, State activeState, Event event, boolean eventLess) {
        Transition result = null;
        Transition transition = null;
        for (State auxState = activeState; result == null && auxState != null; auxState = auxState.getParent()) {
            Iterator iterTransition = activeState.getTransitions().iterator();
            while (result == null && iterTransition.hasNext()) {
                transition = (Transition)iterTransition.next();
                if (eventLess) {
                    result = this.checkEventlessTransition(context, transition);
                    continue;
                }
                result = this.checkNormalTransition(context, transition, event);
            }
        }
        return result;
    }

    private Transition checkNormalTransition(Context context, Transition transition, Event event) {
        Transition result = null;
        if (transition.getEventName() != null) {
            if (this.matchTransition(transition, event)) {
                result = this.checkGuardCondition(context, transition);
            }
        } else {
            result = this.checkGuardCondition(context, transition);
        }
        return result;
    }

    private Transition checkEventlessTransition(Context context, Transition transition) {
        Transition result = null;
        if (transition.getEventName() == null || "".equals(transition.getEventName())) {
            result = this.checkGuardCondition(context, transition);
        }
        return result;
    }

    private boolean matchTransition(Transition transition, Event event) {
        boolean result = false;
        String eventName = event.getName();
        String aux = transition.getEventName();
        aux = aux.endsWith(".") ? aux.substring(0, aux.lastIndexOf(".")) : aux;
        String transitionEventName = aux = aux.endsWith(".*") ? aux.substring(0, aux.lastIndexOf(".*")) : aux;
        result = transitionEventName.contains(" ") ? this.matchMultiEventTransition(eventName, transitionEventName) : this.matchSingleEventTransition(eventName, transitionEventName);
        return result;
    }

    private boolean matchSingleEventTransition(String eventName, String transitionEventName) {
        boolean result = false;
        if (eventName.equals(transitionEventName)) {
            result = true;
        } else if (transitionEventName.length() <= eventName.length()) {
            String[] eventTokens = eventName.split("\\.");
            StringTokenizer stTransitionEventTokens = new StringTokenizer(transitionEventName, ".");
            boolean match = true;
            for (int i = 0; i < eventTokens.length && match && stTransitionEventTokens.hasMoreTokens(); ++i) {
                String transitionEventToken = stTransitionEventTokens.nextToken();
                match = this.matchEventNameToken(eventTokens[i], transitionEventToken);
            }
            result = match && !stTransitionEventTokens.hasMoreTokens();
        }
        return result;
    }

    private boolean matchMultiEventTransition(String eventName, String transitionEventName) {
        boolean result = false;
        StringTokenizer stTransitionEventNames = new StringTokenizer(transitionEventName, " ");
        while (stTransitionEventNames.hasMoreElements() && !result) {
            String transitionEventToken = stTransitionEventNames.nextToken();
            result = this.matchSingleEventTransition(eventName, transitionEventToken);
        }
        return result;
    }

    private boolean matchEventNameToken(String eventToken, String transitionEventToken) {
        transitionEventToken = transitionEventToken.replaceAll("\\*", ".*");
        boolean match = eventToken.matches(transitionEventToken);
        return match;
    }

    private Transition checkGuardCondition(Context context, Transition transition) {
        Transition result = null;
        if (transition.passGuardCondition(context)) {
            result = transition;
        }
        return result;
    }

    private void enterState(Context context, Transition enabledTransition) {
        ArrayList<Transition> aux = new ArrayList<Transition>(1);
        aux.add(enabledTransition);
        this.enterStates(context, aux);
    }

    private void enterStates(Context context, List<Transition> enabledTransitions) {
        TreeSet<State> statesToEnter = new TreeSet<State>((Comparator<State>)StateMachineUtils.entryOrderComparator);
        HashMap<String, State> statesForDefaultEntry = new HashMap<String, State>();
        this.addStatesToEnter(context, enabledTransitions, statesToEnter, statesForDefaultEntry);
        if (DEBUG.get()) {
            this.logFine("Entering states " + statesToEnter);
        }
        for (State state : statesToEnter) {
            if (DEBUG.get()) {
                this.logFine("--> on enter: " + state);
            }
            if (state.getDataModel() != null) {
                context.loadDataModel(state.getDataModel());
            }
            context.addStateToInvoke(state);
            context.addActiveState(state);
            this.executeContent(context, state.getOnEntryExecutables());
            if (statesForDefaultEntry.containsKey(state.getName())) {
                this.executeContent(context, state.getInitialState().getInitialTransition().getExecutables());
            }
            this.manageFinalInEnterState(context, state);
        }
        if (DEBUG.get()) {
            this.logFine("------------------------------------");
        }
    }

    private void executeTransitionContent(Context context, List<Transition> enabledTransitions) {
        if (DEBUG.get()) {
            this.logFine("Enabled transitions {0}", new Object[]{enabledTransitions});
        }
        for (Transition transition : enabledTransitions) {
            if (DEBUG.get()) {
                this.logFine("<--> {0}", new Object[]{transition.toStringVerbose()});
            }
            List executables = transition.getExecutables();
            this.executeContent(context, executables);
        }
        if (DEBUG.get()) {
            this.logFine("------------------------------------");
        }
    }

    private void exitStates(Context context, List<Transition> enabledTransitions) {
        SortedSet activeStates = context.getActiveStates();
        SortedSet<State> statesToExit = this.getStatesToExit(context, enabledTransitions);
        if (DEBUG.get()) {
            this.logFine("Exiting states: " + statesToExit);
        }
        for (State state : statesToExit) {
            context.removeStateToInvoke(state);
        }
        this.manageHistoricStates(context, activeStates, statesToExit);
        for (State state : statesToExit) {
            if (DEBUG.get()) {
                this.logFine("<-- on exit: " + state);
            }
            List onExitExecutables = state.getOnExitExecutables();
            this.executeContent(context, onExitExecutables);
            this.cancelInvokes(context, state);
            context.removeActiveState(state);
            if (state.getDataModel() == null) continue;
            context.removeDatamodel(state.getDataModel());
        }
        if (DEBUG.get()) {
            this.logFine("------------------------------------");
        }
    }

    private void manageHistoricStates(Context context, SortedSet<State> activeStates, SortedSet<State> statesToExit) {
        for (State state : statesToExit) {
            List historyStates = state.getHistoryStates();
            for (State historyState : historyStates) {
                SortedSet<State> historyActiveStates = HistoryTypes.SHALLOW.equals((Object)historyState.getHistoryType()) ? this.extractShallowHistory(context, activeStates, state) : this.extractDeepHistory(context, activeStates, state);
                if (DEBUG.get()) {
                    this.logFine("saving ({0}) states: {1}", new Object[]{historyState, historyActiveStates});
                }
                HashMap<String, SortedSet<State>> historyStatesMap = this.getHistoryMap(context);
                historyStatesMap.put(historyState.getName(), historyActiveStates);
            }
        }
    }

    private HashMap<String, SortedSet<State>> getHistoryMap(Context context) {
        HashMap historyStatesMap = (HashMap)context.getDataByName(HISTORY_STATES);
        return historyStatesMap;
    }

    private SortedSet<State> extractDeepHistory(Context context, SortedSet<State> activeStates, State state) {
        TreeSet<State> historyActiveStates = new TreeSet<State>();
        for (State active : activeStates) {
            if (!active.isDescendant(state) || active.hasChildrens()) continue;
            this.saveHistoricStateDatamodel(context, active);
            historyActiveStates.add(active);
        }
        return historyActiveStates;
    }

    private SortedSet<State> extractShallowHistory(Context context, SortedSet<State> activeStates, State state) {
        TreeSet<State> historyActiveStates = new TreeSet<State>();
        for (State children : state.getChildrens()) {
            if (!activeStates.contains(children)) continue;
            this.saveHistoricStateDatamodel(context, children);
            historyActiveStates.add(children);
            break;
        }
        return historyActiveStates;
    }

    protected void saveHistoricStateDatamodel(Context context, State active) {
        if (active.getDataModel() != null) {
            for (Data data : active.getDataModel().getDataList()) {
                data.saveHistoricData(context);
            }
        }
    }

    private void logFine(String text) {
        this.logCallback.logDebug(text);
    }

    private void logFine(String text, Object[] data) {
        this.logCallback.logDebug(text, data);
    }

    private SortedSet<State> getStatesToExit(Context context, List<Transition> enabledTransitions) {
        TreeSet<State> statesToExit = new TreeSet<State>((Comparator<State>)StateMachineUtils.exitOrderComparator);
        for (Transition transition : enabledTransitions) {
            if (transition.getTargetState(context) == null) continue;
            State ancestor = this.calculateTransitionAncestor(context, transition);
            SortedSet activeStates = context.getActiveStates();
            for (State activeState : activeStates) {
                if (!activeState.isDescendant(ancestor)) continue;
                statesToExit.add(activeState);
            }
        }
        return statesToExit;
    }

    private void addStatesToEnter(Context context, List<Transition> enabledTransitions, SortedSet<State> statesToEnter, Map<String, State> statesForDefaultEntry) {
        for (Transition transition : enabledTransitions) {
            State targetState = transition.getTargetState(context);
            if (targetState == null) continue;
            State ancestor = this.calculateTransitionAncestor(context, transition);
            this.addStatesToEnter(context, targetState, statesToEnter, statesForDefaultEntry);
            this.addAncestorsToStatesToEnter(context, statesToEnter, statesForDefaultEntry, ancestor, targetState);
        }
    }

    private void manageFinalInEnterState(Context context, State state) {
        if (state.isFinal()) {
            State parent = state.getParent();
            this.sendFinalEvent(context, state);
            State grandParent = parent.getParent();
            if (grandParent != null && grandParent.isParallel()) {
                boolean allFinal = true;
                Iterator childrenIter = state.getChildrens().iterator();
                while (allFinal && childrenIter.hasNext()) {
                    State children = (State)childrenIter.next();
                    allFinal = this.isInFinalState(context, children);
                }
                if (allFinal) {
                    this.sendFinalEvent(context, parent);
                }
            }
        }
    }

    private boolean isInFinalState(Context context, State state) {
        boolean result = false;
        if (!state.hasChildrens()) {
            result = state.isFinal();
        } else if (!state.isParallel()) {
            Iterator childrenIter = state.getChildrens().iterator();
            while (!result & childrenIter.hasNext()) {
                State children = (State)childrenIter.next();
                result = context.isActiveState(children) && this.isInFinalState(context, children);
            }
        } else {
            Iterator childrenIter = state.getChildrens().iterator();
            boolean allFinal = true;
            while (allFinal & childrenIter.hasNext()) {
                allFinal = this.isInFinalState(context, (State)childrenIter.next());
            }
            result = allFinal;
        }
        return result;
    }

    private void sendFinalEvent(Context context, State state) {
        Serializable body = state.getDoneData() != null ? state.getDoneData().evaluateDoneData(context) : null;
        BasicEvent event = new BasicEvent(StateMachineUtils.DONE_STATE_MF.format(new Object[]{state.getParent().getName()}), body);
        context.offerInternalEvent((Event)event);
    }

    private void executeContent(Context context, List<Executable> onEntryExecutables) {
        for (Executable executable : onEntryExecutables) {
            this.executeContent(context, executable);
        }
    }

    private void executeContent(Context context, Executable executable) {
        if (DEBUG.get()) {
            this.logFine("exec: {0}", new Object[]{executable});
        }
        executable.run(context);
    }

    private void invokeAll(Context context, State state) {
        List invokes = state.getInvokes();
        for (Invoke invoke : invokes) {
            if (DEBUG.get()) {
                this.logFine("Found Invoke {0} in state {1}", new Object[]{invoke.getId(context), state.getName()});
            }
            invoke.call(state.getName(), context);
            if (!DEBUG.get()) continue;
            this.logFine("Invoke called, resulting session id: {0}", new Object[]{invoke.getId(context)});
        }
    }

    private void applyInvokeFinalize(Context context, Invoke invoke, Event event) {
        if (invoke.getFinalize() != null) {
            if (DEBUG.get()) {
                this.logFine("Apply invoke finalize, session id: {0}", new Object[]{invoke.getId(context)});
            }
            invoke.getFinalize().run(context);
        }
    }

    private void cancelInvokes(Context context, State state) {
        for (Invoke invoke : state.getInvokes()) {
            this.cancelInvoke(context, invoke);
        }
    }

    private void cancelInvoke(Context context, Invoke invoke) {
        if (DEBUG.get()) {
            this.logFine("Cancel invoke, session id: {0}", new Object[]{invoke.getId(context)});
        }
        invoke.cancel(context);
    }

    private void addAncestorsToStatesToEnter(Context context, SortedSet<State> statesToEnter, Map<String, State> statesForDefaultEntry, State ancestor, State targetState) {
        for (State aux = targetState.getParent(); aux != null && !aux.equals(ancestor); aux = aux.getParent()) {
            statesToEnter.add(aux);
            if (!aux.isParallel()) continue;
            for (State parallelChildren : aux.getChildrens()) {
                boolean someStateToEnterIsDescendant = this.isAnyActiveDescendantState(statesToEnter, parallelChildren);
                if (someStateToEnterIsDescendant) continue;
                this.addStatesToEnter(context, parallelChildren, statesToEnter, statesForDefaultEntry);
            }
        }
    }

    private boolean isAnyActiveDescendantState(SortedSet<State> statesToEnter, State parallelChildren) {
        boolean someStateToEnterIsDescendant = false;
        for (State stateToEnter : statesToEnter) {
            if (!stateToEnter.isDescendant(parallelChildren)) continue;
            someStateToEnterIsDescendant = true;
        }
        return someStateToEnterIsDescendant;
    }

    private void addStatesToEnter(Context context, State state, SortedSet<State> statesToEnter, Map<String, State> statesForDefaultEntry) {
        if (state.isHistoryState()) {
            HashMap<String, SortedSet<State>> historyStatesMap = this.getHistoryMap(context);
            if (historyStatesMap.containsKey(state.getName())) {
                SortedSet<State> historicStates = historyStatesMap.get(state.getName());
                for (State historicActiveState : historicStates) {
                    this.addStatesToEnter(context, historicActiveState, statesToEnter, statesForDefaultEntry);
                    this.addAncestorsToStatesToEnter(context, statesToEnter, statesForDefaultEntry, state.getParent(), historicActiveState);
                }
            } else {
                for (Transition historicTransition : state.getTransitions()) {
                    State targetHistoricTransition = historicTransition.getTargetState(context);
                    this.addStatesToEnter(context, targetHistoricTransition, statesToEnter, statesForDefaultEntry);
                }
            }
        } else {
            statesToEnter.add(state);
            if (state.isParallel()) {
                for (State children : state.getChildrens()) {
                    this.addStatesToEnter(context, children, statesToEnter, statesForDefaultEntry);
                }
            } else if (state.hasChildrens()) {
                statesForDefaultEntry.put(state.getName(), state);
                State target = state.getInitialState().getInitialTransition().getTargetState(context);
                this.addStatesToEnter(context, target, statesToEnter, statesForDefaultEntry);
            }
        }
    }

    private State calculateTransitionAncestor(Context context, Transition transition) {
        State result = null;
        State targetState = transition.getTargetState(context);
        result = transition.isInternal() && targetState != null && targetState.isDescendant(transition.getSourceState(context)) ? transition.getSourceState(context) : this.searchLCA(context, transition);
        return result;
    }

    public void registerListener(FSMListener listener) {
        this.listeners.add(listener);
    }

    public void unRegisterListener(FSMListener listener) {
        this.listeners.remove(listener);
    }

    public void setEngine(StateMachineEngine engine) {
        this.engine = engine;
    }

    public void setLogCallback(FSMLogCallback logCallback) {
        this.logCallback = logCallback;
    }
}

