/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.basic;

import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Conditional;
import com.nosolojava.fsm.runtime.executable.Executable;
import java.util.ArrayList;
import java.util.List;

public class BasicConditional
implements Conditional {
    private static final long serialVersionUID = -2633061454337049104L;
    protected final String condition;
    protected final List<Executable> executables = new ArrayList<Executable>();

    public BasicConditional(String condition) {
        this.condition = condition;
    }

    public BasicConditional(String condition, List<Executable> executables) {
        this(condition);
        this.executables.addAll(executables);
    }

    protected boolean evaluateCondition(Context context) {
        return context.evaluateConditionGuardExpresion(this.condition);
    }

    public void run(Context context) {
        this.runIf(context);
    }

    public boolean runIf(Context context) {
        boolean result = false;
        if (this.evaluateCondition(context)) {
            result = true;
            this.executeNested(context);
        }
        return result;
    }

    private void executeNested(Context context) {
        if (this.executables != null) {
            for (Executable executable : this.executables) {
                executable.run(context);
            }
        }
    }
}

