/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.basic;

import com.nosolojava.fsm.model.state.HistoryState;
import com.nosolojava.fsm.model.state.HistoryTypes;
import com.nosolojava.fsm.model.state.State;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;

public class BasicHistorySave
implements Executable {
    private static final long serialVersionUID = -915001182581264297L;
    private final String stateName;
    private final HistoryState historyState;
    private final String savingStatesName;

    public BasicHistorySave(String stateName, HistoryState historyState) {
        this.stateName = stateName;
        this.historyState = historyState;
        this.savingStatesName = stateName + "_" + historyState.getId();
    }

    public void run(Context context) {
        State state = context.getState(this.stateName);
        SortedSet activeStates = context.getActiveStates();
        Collection<State> activeChildrens = new ArrayList<State>();
        if (HistoryTypes.SHALLOW.equals((Object)this.historyState.getType())) {
            for (State children : state.getChildrens()) {
                if (!activeStates.contains(children)) continue;
                activeChildrens.add(children);
                break;
            }
        } else {
            activeChildrens = this.calculateActiveChildrensRec(state, activeStates, activeChildrens);
        }
        context.createVarIfDontExist(this.savingStatesName, activeChildrens);
    }

    private Collection<State> calculateActiveChildrensRec(State state, SortedSet<State> activeStates, Collection<State> activeChildrens) {
        for (State children : state.getChildrens()) {
            if (!activeStates.contains(children)) continue;
            activeChildrens.add(children);
            if (!children.hasChildrens()) break;
            activeChildrens = this.calculateActiveChildrensRec(children, activeStates, activeChildrens);
            break;
        }
        return activeChildrens;
    }
}

