/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic;

import com.nosolojava.fsm.model.externalcomm.Finalize;
import com.nosolojava.fsm.model.externalcomm.Invoke;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.Executable;
import java.text.MessageFormat;
import java.util.List;

public class BasicFinalize
implements Finalize {
    private static final long serialVersionUID = 5063734037915308094L;
    private final List<Executable> executables;
    private Invoke invoke = null;
    private MessageFormat eventParamMF = new MessageFormat("_event.data.{0}");

    public BasicFinalize(List<Executable> executables) {
        this.executables = executables;
    }

    public void run(Context context) {
        if (this.executables != null && !this.executables.isEmpty()) {
            for (Executable executable : this.executables) {
                executable.run(context);
            }
        } else {
            List locations = this.invoke.getLocations();
            for (String location : locations) {
                String expression = this.eventParamMF.format(new String[]{location});
                Object value = context.getDataByExpression(expression);
                if (value == null) continue;
                context.updateData(location, value);
            }
        }
    }

    public void setInvoke(Invoke invoke) {
        this.invoke = invoke;
    }
}

