/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic;

import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicInvokeInfo;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicMessage;
import com.nosolojava.fsm.model.config.exception.ConfigurationException;
import com.nosolojava.fsm.model.datamodel.Body;
import com.nosolojava.fsm.model.externalcomm.Finalize;
import com.nosolojava.fsm.model.externalcomm.Invoke;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeHandler;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeInfo;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicInvoke
implements Invoke {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String id;
    private final String idLocation;
    private final URI src;
    private final String srcExpression;
    private final String type;
    private final String typeExpression;
    private final boolean autoForward;
    private final Finalize finalize;
    private InvokeHandler invokeHandler;
    private Body body;
    private MessageFormat targetMF = new MessageFormat("#{0}");

    public BasicInvoke(String id, String idLocation, URI src, String srcExpression, String type, String typeExpression, boolean autoForward, Finalize finalize, Body body) throws ConfigurationException {
        if (id != null && idLocation != null) {
            throw new ConfigurationException("Cant be Id and Idlocation in the same invoke element.");
        }
        if (src != null && srcExpression != null) {
            throw new ConfigurationException("Cant be src and srcExpression in the same invoke element.");
        }
        if (type != null && typeExpression != null) {
            throw new ConfigurationException("Cant be type and typeExpression in the same invoke element.");
        }
        this.id = id;
        this.idLocation = idLocation;
        this.src = src;
        this.type = type;
        this.typeExpression = typeExpression;
        this.srcExpression = srcExpression;
        this.autoForward = autoForward;
        this.finalize = finalize;
        if (this.finalize != null) {
            this.finalize.setInvoke((Invoke)this);
        }
        this.body = body;
    }

    public String getType(Context context) {
        String result = this.type != null ? this.type : (String)context.getDataByExpression(this.typeExpression);
        return result;
    }

    public URI getSource(Context context) throws URISyntaxException {
        Object res;
        URI result = null;
        if (this.src != null) {
            result = this.src;
        } else if (this.srcExpression != null && (res = context.getDataByExpression(this.srcExpression)) != null) {
            String aux = (String)res;
            result = new URI(aux);
        }
        return result;
    }

    public String getId(Context context) {
        String result = null;
        result = this.id != null ? this.id : (String)context.getDataByName(this.idLocation);
        return result;
    }

    public boolean isAutoforward() {
        return this.autoForward;
    }

    public Finalize getFinalize() {
        return this.finalize;
    }

    public Object getBody(Context context) {
        Serializable result = null;
        if (this.body != null) {
            result = (Serializable)this.body.evaluateBody(context);
        }
        return result;
    }

    public void call(String stateId, Context context) {
        if (this.idLocation != null) {
            String result = stateId + "." + UUID.randomUUID().toString();
            context.updateData(this.idLocation, (Object)result);
        }
        String type = this.getType(context);
        if (this.invokeHandler == null || !this.invokeHandler.getType().equals(type)) {
            this.invokeHandler = context.getInvokeHandler(type);
        }
        BasicInvokeInfo invokeInfo = null;
        try {
            invokeInfo = new BasicInvokeInfo(this, context);
            this.invokeHandler.invokeService((InvokeInfo)invokeInfo, context);
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, "Error parsing invoke uri. {0}", new Object[]{this});
        }
    }

    protected Message createMessage(Event event, Context context) {
        String id = this.getId(context);
        String name = event.getName();
        URI sourceURI = event.getOrigin();
        URI targetURI = URI.create(this.targetMF.format(new Object[]{id}));
        Object body = this.getBody(context);
        BasicMessage message = new BasicMessage(id, name, sourceURI, targetURI, body);
        return message;
    }

    public void manageEvent(Event event, Context context) {
        Message message = this.createMessage(event, context);
        this.invokeHandler.sendMessageToService(message);
    }

    public void cancel(Context context) {
        this.invokeHandler.endSession(this.getId(context));
    }

    public List<String> getLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.body != null) {
            locations.addAll(this.body.getLocations());
        }
        return locations;
    }
}

