/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.invokeHandler;

import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.AbstractBasicInvokeHandler;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.basic.BasicMessage;
import com.nosolojava.fsm.impl.runtime.executable.externalcomm.io.ConsoleIOProcessor;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.executable.externalcomm.IOProcessor;
import com.nosolojava.fsm.runtime.executable.externalcomm.InvokeInfo;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConsoleInvokeHandler
extends AbstractBasicInvokeHandler {
    private static final long serialVersionUID = 1106621957118194732L;
    public static String TYPE = "console";
    private ConcurrentMap<String, Thread> taskMap = new ConcurrentHashMap<String, Thread>();
    private Lock lock = new ReentrantLock();

    @Override
    public String getType() {
        return "console";
    }

    @Override
    public void invokeServiceInternal(InvokeInfo invokeInfo, Context context) {
        if (!this.taskMap.containsKey(context.getSessionId())) {
            this.lock.lock();
            if (!this.taskMap.containsKey(context.getSessionId())) {
                ReadConsoleTask readConsoleTask = new ReadConsoleTask(invokeInfo.getInvokeId(), context);
                Thread t = new Thread(readConsoleTask);
                t.start();
                this.taskMap.put(invokeInfo.getInvokeId(), t);
            }
            this.lock.unlock();
        }
    }

    @Override
    public void sendMessageToService(Message message, Context context) {
        IOProcessor ioProcessor = context.searchIOProcessor(ConsoleIOProcessor.NAME);
        ioProcessor.sendMessageFromFSM(message);
    }

    @Override
    public void onEndSession(String invokeId, Context context) {
        Thread thread;
        if (this.taskMap.containsKey(invokeId) && (thread = (Thread)this.taskMap.get(invokeId)).isAlive()) {
            System.out.println("Interrupting thread " + invokeId);
            thread.interrupt();
            System.out.println("Please introduce control+D in your keyboard to finish session.");
        }
    }

    class ReadConsoleTask
    implements Runnable {
        private final String invokeId;
        private final Context context;
        private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        public ReadConsoleTask(String invokeId, Context context) {
            this.invokeId = invokeId;
            this.context = context;
        }

        @Override
        public void run() {
            String result = null;
            while (!Thread.interrupted() && ConsoleInvokeHandler.this.taskMap.containsKey(this.invokeId)) {
                try {
                    result = null;
                    result = this.br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                if (result == null) continue;
                Message message = BasicMessage.createSimpleSCXMLMessage(result, this.context.getParentSessionId(), this.context);
                IOProcessor ioProcessor = this.context.searchIOProcessor("scxml");
                ioProcessor.sendMessageFromFSM(message);
            }
            System.out.println("Ending thread " + this.invokeId);
            try {
                this.br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ConsoleInvokeHandler.this.taskMap.remove(this.invokeId);
        }
    }
}

